block('b-layout-form')(

    tag()('form'),

    js()(true),

    mix()(function() {
        return !this.ctx.mix || {};
    }),

    attrs()(function() {
        var ctx = this.ctx,
            result = {
                action: ctx.action || '',
                method: ctx.method || 'POST'
            };

        ctx.target && (result.target = ctx.target);

        return result;
    }),

    content()(function() {
        var res = [],
            ctx = this.ctx,
            mixes = this.ctx.mixes || {},
            identify = this.identify.bind(this);

        mixes.row = mixes.row || [];
        mixes.control = mixes.control || [];
        mixes.info = mixes.info || [];
        mixes.label = mixes.label || [];

        ctx.header && res.push({
            elem: 'row',
            elemMods: { type: 'header' },
            mix: mixes && mixes.header,
            content: typeof ctx.header === 'string' ?
                {
                    elem: 'header',
                    tag: 'h2',
                    content: ctx.header
                } :
                ctx.header
        });

        ctx.hiddenInputs && res.push({
            elem: 'row',
            elemMods: { type: 'hidden-inputs' },
            content: ctx.hiddenInputs.filter(function(i) {
                return !!i
            }).map(function(input) {
                return {
                    block: 'b-hidden',
                    mix: [
                        {
                            block: 'b-layout-form',
                            elem: 'hidden-input'
                        }
                    ].concat(input.mix || []),
                    mods: input.mods,
                    name: input.name,
                    value: input.value
                };
            })
        });

        if (ctx.rows) {
            res = res.concat(ctx.rows.filter(function(r) {
                return r;
            }).map(function(row) {
                var elemRow = {
                        elem: 'row',
                        content: []
                    },
                    rowMixes = row.mixes || {},
                    inputId = identify();

                rowMixes && rowMixes.row && (elemRow.mix = rowMixes.row);

                elemRow.mix = rowMixes.row ? mixes.row.concat(rowMixes.row) : mixes.row;

                if (row.mix)
                    elemRow.mix = (elemRow.mix || []).concat(row.mix);

                if (row.block || row.elem) {
                    elemRow.content = row;

                    return elemRow;
                }

                if (row.attrs && row.attrs.row) {
                    elemRow.attrs = row.attrs.row;
                }

                row.label && elemRow.content.push({
                    elem: 'cell',
                    elemMods: { type: 'label' },
                    mix: rowMixes.label ? mixes.label.concat(rowMixes.label) : mixes.label,
                    content: typeof row.label === 'string' ?
                        {
                            elem: 'label',
                            content: row.label,
                            controlId: inputId
                        } :
                        row.label
                });

                if (row.control) {
                    if (typeof row.control === 'object' && !Array.isArray(row.control)) {
                        row.control.block === 'checkbox' &&
                            (row.control.checkboxAttrs || (row.control.checkboxAttrs = {}));

                        if (typeof (row.control.checkboxAttrs || row.control).id == 'undefined') {
                            (row.control.checkboxAttrs || row.control).id = inputId;
                        }
                    }

                    elemRow.content.push({
                        elem: 'cell',
                        elemMods: { type: 'control' },
                        mix: rowMixes.control ? mixes.control.concat(rowMixes.control) : mixes.control,
                        content: row.control
                    });
                }

                row.info && elemRow.content.push({
                    elem: 'cell',
                    elemMods: { type: 'info' },
                    mix: rowMixes.info ? mixes.info.concat(rowMixes.info) : mixes.info,
                    content: row.info
                });

                return elemRow;
            }, this));
        }

        ctx.submit && res.push({
            elem: 'row',
            mix: mixes && mixes.submit,
            elemMods: { type: 'submit' },
            content: [
                {
                    elem: 'validation-message',
                    elemMods: { hidden: true }
                },
                typeof ctx.submit === 'string' ?
                    {
                        block: 'button',
                        type: 'submit',
                        content: ctx.submit
                    } :
                    ctx.submit
            ]
        });

        return res;
    }),

    elem('label')(
        tag()('label'),
        attrs()(function() {
            return this.ctx.controlId && {
                for: this.ctx.controlId
            };
        }))
);
