block('b-layout-form2')(   //grid

    content()(function() {
        var res = [],
            ctx = this.ctx,
            mixes = ctx.mixes || {};

        ctx.hiddenInputs && res.push({
            elem: 'group',
            mix: [{ block: 'b-layout-form2', elem: 'hidden-group' }].concat(ctx.hiddenInputs.mixes || []),
            content: ctx.hiddenInputs
                .filter(function(i) {
                    return !!i;
                })
                .map(function(input) {
                    return {
                        block: 'b-hidden',
                        mix: [{ block: 'b-layout-form2', elem: 'hidden-input' }].concat(input.mix || []),
                        name: input.name,
                        value: input.value
                    };
                })
        });

        ctx.header && res.push({
            elem: 'group',
            mix: [{ block: 'b-layout-form2', elem: 'header-group' }].concat(ctx.header.mixes || []),
            content: [
                {
                    elem: 'group-name',
                    content: ctx.header.name || []
                },
                {
                    elem: 'group-cell',
                    content: ctx.header.cells
                        .filter(function(cell) {
                            return !!cell;
                        })
                        .map(function(cell) {
                            return {
                                elem: 'cell',
                                elemMods: { type: 'left' },
                                mix: (mixes.left || []).concat(cell.mixes || []),
                                content: cell
                            };
                        })
                }
            ]
        });

        //group->rows
        //если объект -> это группа
        //список элементов: cells->name, name->cells, cells, name
        //если массив - только cells, без обертки группы
        res = ctx.groups && res.concat(ctx.groups.filter(function(group) {
            return !!group;
        }).map(function(group) {
            var groupElem = {
                        //group
                    elem: 'group',
                    mix: (mixes.group || []).concat(group.mixes || []),
                    content: []
                },
                cellElem = {
                        //rows
                    elem: 'group-cell',
                    mix: [],
                    content: []
                },
                groupName = {
                        //common
                    elem: 'group-name',
                    content: group.name
                };

            if (group.type == 'expander') {
                groupName = {
                    elem: 'group-name',
                    mix: [{ block: group.mixName, elem: 'expander' }],
                    content: {
                        block: 'expander',
                        content: [
                            { elem: 'text', tag: 'i', content: group.name },
                            { block: 'icon', mods: { type: 'expander', theme: 'light' } }
                        ]
                    }
                };

                cellElem.mix.push({ block: group.mixName, elem: 'extra' });
            }

            !!group.name && groupElem.content.push(groupName);

            //вынести обработку cell-ов в отдельный элемент
            group.cells && groupElem.content.push(cellElem);

            if (group.cells) {
                cellElem.content = cellElem.content.concat(
                        group.cells.reduce(function(res, cell) {

                            if (cell) {
                                var cellContent = Object.keys(cell).reduce(function(res, key) {

                                    if (/left|center|right/.test(key)) {
                                        res.push({
                                            elem: 'cell',
                                            mix: (mixes[key] || [])
                                                .concat(cell.mixes || [])
                                                .concat(cell[key]['mixes'] || []),
                                            content: cell[key]
                                        });
                                    }

                                    return res;
                                }, []);

                                cellContent.length > 1 && (cellContent = {
                                    elem: 'row',
                                    elemMods: { count: cellContent.length },
                                    mix: cell.mixesRow || [],
                                    content: cellContent
                                });

                                res.push(cellContent);
                            }

                            return res;
                        }, [])
                    );
            }

            return groupElem;
        }));

        ctx.submit && (ctx.submit.position = ctx.submit.position || 'left');
        ctx.submit && res.push({
            elem: 'group',
            mix: [{ block: 'b-layout-form2', elem: 'submit-group' }].concat(ctx.submit.mixes || []),
            content: [
                {
                    elem: 'group-name',
                    content: '&nbsp'
                },
                {
                    elem: 'group-cell',
                    content: ctx.submit.control
                }
            ]
        });

        return res;
    })
);
