/**
* @param {Object} tabs
    * @param {Array} tabs.keys массив с ключами табов
    * @param {Object} tabs.countItems Объект с количеством элементов в табе
    * @param {Object} [tabs.content] Объект, переопределяющий стандартные названия табов
    * @param {String} [tabs.defaultKey = 'active'] ключ таба по умолчанию (значение в параметр tab не добавляется)
    * @param {Object} [tabs.extra.urlParams] Объект расширяющий параметры ссылок для табов, ключи которых
        содержатся в ключе этого объекта
    * @param {Function} [tabs.extra.disabled] Функция дополнительных условий для выставления табу модификатора
        disabled_yes
* @param {Array} links Массив с ссылками, отображающихся справа от табов
* @param {Boolean} tabAsCmd Флаг для случая, когда табы являются другими cmd
*/
block('b-list-tabs').def()(function() {
    var data = this.data,
        ctx = this.ctx,
        form = data.FORM,
        tabs = ctx.tabs,
        cmd = form.cmd,
        tabsContent = this.extend({
            active: iget2('b-list-tabs', 'aktivnye', 'Активные'),
            all: iget2('b-list-tabs', 'vse', 'Все'),
            arch: iget2('b-list-tabs', 'arhiv', 'Архив'),
            planned: iget2('b-list-tabs', 'planiruemye', 'Планируемые'),
            converted: iget2('b-list-tabs', 'skonvertirovannye', 'Сконвертированные'),
            troubled: iget2('b-list-tabs', 'troubled', 'Проблемные')
        }, tabs.content),
        defaultTab = tabs.defaultKey || 'active',
        currentTab = form.tab || defaultTab,
        extra = tabs.extra || {},
        getTabMod = function(tabKey, countItems) {
            var mods = {};

            currentTab == tabKey && (mods['current'] = 'yes');

            extra.disabled &&
                (mods['disabled'] = extra['disabled'].apply(this, arguments)) ||
                !countItems[tabKey] && (mods['disabled'] = 'yes');

            return mods;
        },
        getTabUrlParams = function(tabKey, defaultTab) {
            return extra.urlParams ?
                extra['urlParams'].apply(this, arguments) :
                u.getUrlParams(['cmd', 'page', 'search'], {
                    tab: tabKey
                });
        },
        links = ctx.links || [];

    return {
        block: 'b-menu-horiz',
        mods: {
            layout: 'complex'
        },
        // в контексте может быть переданы миксы: массив | объект | undefined
        // нужно к миксам из контекста добавить еще один блок (он должен быть последним)
        mix: [].concat(ctx.mix || []).concat({
            block: ctx.block,
            mods: ctx.mods,
            js: true
        }),
        content: tabs.keys.map(function(tabKey) {
            var tabMod = getTabMod(tabKey, tabs.countItems),
                noLink = tabMod.current || tabMod.disabled;

            return {
                elem: 'item',
                mix: [{
                    block: 'b-list-tabs',
                    elem: 'tab',
                    elemMods: tabMod
                }],
                content: noLink ?
                    tabsContent[tabKey] : {
                        block: 'link',
                        mix: {
                            block: 'b-list-tabs',
                            elem: 'tab-link'
                        },
                        url: u.getUrl(ctx.tabAsCmd ? tabKey : cmd, getTabUrlParams(tabKey, defaultTab)),
                        content: tabsContent[tabKey]
                    }
            };
        }).concat({
            elem: 'gap'
        },
            links.map(function(link) {
                return {
                    elem: 'item',
                    mix: [{
                        block: 'b-list-tabs',
                        elem: 'tab'
                    }].concat(link.tabItemMix || []),
                    content: link
                };
            })
        )
    };
});
