block('b-list-warn-place-filter-form')(
    content()(function() {
        var data = this.ctx.data;

        return {
            block: 'b-layout-form',
            mods: { 'auto-append-colons': 'yes' },
            mixes: {
                row: [{
                    block: 'b-list-warn-place-filter-form',
                    elem: 'row'
                }],
                label: [{
                    block: 'b-list-warn-place-filter-form',
                    elem: 'label'
                }],
                control: [{
                    block: 'b-list-warn-place-filter-form',
                    elem: 'control'
                }],
                submit: [{
                    block: 'b-list-warn-place-filter-form',
                    elem: 'submit'
                }]
            },
            action: data.script,
            method: 'GET',
            submit: {
                block: 'button',
                type: 'submit',
                mods: { theme: 'action' },
                content: iget2('b-list-warn-place-filter-form', 'pokazat', 'Показать')
            },
            attrs: { name: 'frm_select' },
            rows: (function() {
                var loginByCid = data.ws_cid != 0 && (function() {
                        var res = false;

                        data.camps.some(function(camp) {
                            if (camp.cid == data.ws_cid) {
                                res = camp.login;
                                return true;
                            }

                            return false;
                        });

                        return res;
                    }()),
                    selectedClientLogin = (data.ws_client != 0 && data.ws_client) || loginByCid;

                return [
                    {
                        label: iget2('b-list-warn-place-filter-form', 'frazy', 'Фразы'),
                        control: {
                            block: 'b-list-warn-place-filter-form',
                            elem: 'select',
                            name: 'ws_place',
                            options: {
                                0: iget2('b-list-warn-place-filter-form', 'all-with-traffic-changes', 'все, изменившие трафик'),
                                2: iget2('b-list-warn-place-filter-form', 'vytesnennye-iz-poiska', 'вытесненные из поиска'),
                                3: iget2('b-list-warn-place-filter-form', 'vytesnennye-iz-premium-pokazov', 'вытесненные из премиум-показов')
                            },
                            currentValue: data.ws_place || 0
                        }
                    },
                    {
                        label: iget2('b-list-warn-place-filter-form', 'period', 'Период'),
                        control: {
                            block: 'b-list-warn-place-filter-form',
                            elem: 'select',
                            name: 'ws_time',
                            options: {
                                '3h': iget2('b-list-warn-place-filter-form', 'za-poslednie-3-chasa', 'за последние 3 часа'),
                                '6h': iget2('b-list-warn-place-filter-form', 'za-poslednie-6-chasov', 'за последние 6 часов'),
                                '12h': iget2('b-list-warn-place-filter-form', 'za-poslednie-12-chasov', 'за последние 12 часов'),
                                '1d': iget2('b-list-warn-place-filter-form', 'za-poslednie-sutki', 'за последние сутки'),
                                '2d': iget2('b-list-warn-place-filter-form', 'za-poslednie-2-sutok', 'за последние 2 суток'),
                                '7d': iget2('b-list-warn-place-filter-form', 'za-poslednie-7-sutok', 'за последние 7 суток')
                            },
                            currentValue: data.ws_time || '3h'
                        }
                    },
                    {
                        label: iget2('b-list-warn-place-filter-form', 'kampaniya', 'Кампания'),
                        control: {
                            block: 'b-list-warn-place-filter-form',
                            elem: 'select',
                            selectMods: { disabled: !data.camps.length ? 'yes' : '' },
                            name: 'ws_cid',
                            options: u.deepExtend({ 0: iget2('b-list-warn-place-filter-form', 'vse-104', 'все') },
                                data.camps.reduce(function(res, camp) {
                                    res[camp.cid] = '№ ' + camp.cid + ' - "' + camp.name + '"';

                                    return res;
                                }, {})),
                            currentValue: data.ws_cid || 0
                        }
                    },
                    !data.isClient && {
                        label: iget2('b-list-warn-place-filter-form', 'klient', 'Клиент'),
                        control: [
                            {
                                block: 'b-list-warn-place-filter-form',
                                elem: 'select',
                                selectMods: { disabled: !data.clients.length ? 'yes' : '' },
                                name: 'ws_client',
                                options: u.deepExtend({ 0: iget2('b-list-warn-place-filter-form', 'po-vsem-klientam', 'по всем клиентам') },
                                    data.clients.reduce(function(res, client, index) {
                                        res[client.login] = (index + 1) + '. ' + client.FIO + ' (' + client.login + ')';

                                        return res;
                                    }, {})),
                                currentValue: data.ws_client || 0
                            },
                            selectedClientLogin && {
                                block: 'link',
                                mix: [{
                                    block: 'b-list-warn-place-filter-form',
                                    elem: 'show-camps-link'
                                }],
                                attrs: { target: '_blank' },
                                url: u.getUrl('showCamps', { ulogin: selectedClientLogin }),
                                content: iget2('b-list-warn-place-filter-form', 'vse-kampanii-klienta', 'Все кампании клиента...')
                            }
                        ]
                    },
                    {
                        label: iget2('b-list-warn-place-filter-form', 'status', 'Статус'),
                        control: {
                            block: 'b-list-warn-place-filter-form',
                            elem: 'select',
                            name: 'ws_done',
                            options: {
                                0: iget2('b-list-warn-place-filter-form', 'neproverennye', 'непроверенные'),
                                1: iget2('b-list-warn-place-filter-form', 'proverennye', 'проверенные')
                            },
                            currentValue: data.ws_done || 0
                        }
                    }
                ];
            }.call(this)),

            hiddenInputs: u._.compact([
                data.uid_par && {
                    name: data.uid_par.key,
                    value: data.uid_par.value
                },
                {
                    name: 'cmd',
                    value: 'listWarnPlace'
                },
                data.sort && {
                    name: 'sort',
                    value: data.sort
                },
                data.reverse && {
                    name: 'reverse',
                    value: data.reverse
                }
            ])
        };
    }),

    elem('select').def()(function() {
        return applyCtx({
            block: 'select',
            mix: [{
                block: 'b-list-warn-place-filter-form',
                elem: 'select'
            }],
            mods: this.ctx.selectMods || {},
            name: this.ctx.name,
            content: [
                {
                    block: 'button',
                    content: this.ctx.options[this.ctx.currentValue]
                },
                {
                    elem: 'control',
                    content: Object.keys(this.ctx.options).map(function(key) {
                        var option = {
                            elem: 'option',
                            attrs: { value: key },
                            content: u.escapeHTML(this.ctx.options[key])
                        };

                        if (key == this.ctx.currentValue) {
                            option.attrs.selected = 'selected';
                        }

                        return option;
                    }, this)
                }
            ]
        });
    })
);
