block('b-list-warn-place-phrases-table')(
    js()(true),

    content()(function() {
        var data = this.ctx.data,
            viewingDone = data.ws_done == 1,
            fixedEncodeURI = function(str) { //RFC3986, как в перле
                return encodeURI(str).replace(/%5B/g, '[').replace(/%5D/g, ']');
            },
            //текущие параметры фильтра
            filterParams = (function() {
                var result = {};

                typeof data.sort != 'undefined' && (result.sort = data.sort);
                typeof data.reverse != 'undefined' && (result.reverse = data.reverse);
                ['ws_place', 'ws_time', 'ws_cid', 'ws_done', 'ws_client'].forEach(function(key) {
                    (typeof data[key] != 'undefined') && (result[key] = data[key]);
                });

                return result;
            }()),
            /**
             * Функция, расширяющая переданный хэш текущими параметрами фильтрации
             * Предполагается, что результат функции будет использоваться для формировании ссылки на объявление
             * @param {Object} params расширяемый хэш
             * @returns {Object}
             */
            withCurrentFilterParams = function(params) {
                Object.keys(filterParams).forEach(function(key) {
                    var resultKey = {
                        sort: 'msort',
                        reverse: 'mreverse'
                    }[key] || key;

                    params[resultKey] = fixedEncodeURI(filterParams[key]);
                });

                return params;
            };

        return {
            block: 'b-layout-form',
            mix: [
                {
                    block: 'b-list-warn-place-phrases-table',
                    elem: 'form'
                },
                {
                    block: 'i-form',
                    mods: { submit: 'bem-event' }
                }
            ],

            action: data.script,
            method: 'POST',
            attrs: { name: 'frm_move' },

            mixes: {
                submit: [{
                    block: 'b-list-warn-place-phrases-table',
                    elem: 'submit'
                }]
            },

            submit: viewingDone ?
                iget2('b-list-warn-place-phrases-table', 'perenesti-v-neproverennye', 'Перенести в непроверенные') :
                iget2('b-list-warn-place-phrases-table', 'perenesti-v-proverennye', 'Перенести в проверенные'),

            hiddenInputs: u._.compact(u.flatten([
                {
                    name: 'cmd',
                    value: 'doneWarnPlace'
                },
                viewingDone && {
                    name: 'undone',
                    value: '1'
                },
                data.uid_par && {
                    name: data.uid_par.key,
                    value: data.uid_par.value
                },
                Object.keys(filterParams).map(function(key) {
                    return {
                        name: key,
                        value: filterParams[key]
                    }
                })
            ])),

            rows: [
                {
                    block: 'b-checkboxes-group',
                    js: true,
                    mix: [{
                        block: 'b-list-warn-place-phrases-table',
                        elem: 'checkboxes-group'
                    }],
                    content: {
                        block: 'b-data-table',
                        mix: [{
                            block: 'b-list-warn-place-phrases-table',
                            elem: 'table'
                        }, {
                            block: 'b-style-table',
                            mods: { theme: 'gray-list' }
                        }],
                        mods: {
                            sortable: 'server',
                            'has-num-column': 'yes'
                        },
                        disabledSort: true,
                        disabledReverse: true,
                        sortBy: data.sort,
                        columns: u.flatten([
                            {
                                key: 'id',
                                sortDisable: true,
                                title: {
                                    block: 'checkbox',
                                    mix: [{
                                        block: 'b-checkboxes-group',
                                        elem: 'item'
                                    }],
                                    checkboxAttrs: {
                                        title: iget2('b-list-warn-place-phrases-table', 'vydelit-vse', 'выделить все'),
                                        autocomplete: 'off'
                                    }
                                },
                                transformData: function(rowData) {
                                    return {
                                        block: 'checkbox',
                                        mix: [{
                                            block: 'b-checkboxes-group',
                                            elem: 'item'
                                        }],
                                        checkboxAttrs: {
                                            autocomplete: 'off',
                                            name: 'id',
                                            value: rowData.id + ':' + rowData.cid,
                                            id: rowData.id
                                        }
                                    }
                                }
                            },
                            {
                                key: 'phrase',
                                title: iget2('b-list-warn-place-phrases-table', 'fraza', 'Фраза'),
                                transformData: function(rowData) {
                                    return {
                                        block: 'b-list-warn-place-phrases-table',
                                        elem: 'phrase',
                                        elemMods: { 'old-place': rowData.old_place },
                                        content: {
                                            tag: 'label',
                                            attrs: { for: rowData.id },
                                            content: rowData.phrase
                                        }
                                    };
                                }
                            },
                            {
                                key: 'cid',
                                title: iget2('b-list-warn-place-phrases-table', 'kampaniya', 'Кампания'),
                                transformData: function(rowData) {
                                    var urlObject = withCurrentFilterParams({
                                            cid: rowData.cid,
                                            page: '1'
                                        }),
                                        attrs = {};

                                    if (!data.isClient) {
                                        urlObject.ulogin = rowData.login;
                                    }
                                    if (data.ws_done != 1) {
                                        urlObject.wp = '1';
                                    }
                                    if (data.sort == 'cid') {
                                        attrs.name = rowData.cid;
                                    }

                                    return {
                                        block: 'link',
                                        mix: [{
                                            block: 'b-list-warn-place-phrases-table',
                                            elem: 'cid'
                                        }],
                                        url: u.getUrl('showCamp', urlObject) + '#' + rowData.bid,
                                        content: rowData.cid,
                                        attrs: attrs
                                    };
                                }
                            },
                            {
                                key: 'adgroup_id',
                                title: iget2('b-list-warn-place-phrases-table', 'gruppa', 'Группа'),
                                transformData: function(rowData) {
                                    var urlObject = withCurrentFilterParams({
                                        cid: rowData.cid,
                                        page: '1',
                                        adgroup_id: rowData.adgroup_id
                                    });

                                    if (!data.isClient) {
                                        urlObject.ulogin = rowData.login;
                                    }
                                    if (data.ws_done != 1) {
                                        urlObject.wp = '1';
                                    }

                                    return {
                                        block: 'link',
                                        mix: [{
                                            block: 'b-list-warn-place-phrases-table',
                                            elem: 'cid'
                                        }],
                                        url: u.getUrl('showCamp', urlObject),
                                        content: rowData.adgroup_id
                                    };
                                }
                            },
                            {
                                key: 'old_place',
                                title: iget2('b-list-warn-place-phrases-table', 'vytesnena-nbsp-iz', 'Вытеснена&nbsp;из'),
                                transformData: function(rowData) {
                                    return {
                                        block: 'b-list-warn-place-phrases-table',
                                        elem: 'old-place',
                                        content: {
                                            23: iget2('b-list-warn-place-phrases-table', 'from-search', 'поиска'), // GARANT(1) -> GUARANTEE4(23)
                                            12: iget2('b-list-warn-place-phrases-table', 'from-premium', 'премиум-показов'), // PREMIUM(3) -> PREMIUM3(12)
                                            13: iget2('b-list-warn-place-phrases-table', 'from-premium', 'премиум-показов') // PREMIUM(4) -> PREMIUM4(13)
                                        }[rowData.old_place]
                                    };
                                }
                            },
                            {
                                key: 'shows',
                                title: iget2('b-list-warn-place-phrases-table', 'pokazov', 'Показов'),
                                reverse: '1'
                            },
                            {
                                key: 'clicks',
                                title: iget2('b-list-warn-place-phrases-table', 'klikov', 'Кликов'),
                                reverse: '1'
                            },
                            {
                                key: 'ctr',
                                title: iget2('b-list-warn-place-phrases-table', 'ctr', 'CTR'),
                                reverse: '1'
                            },
                            !data.isClient && [
                                {
                                    key: 'fio',
                                    title: iget2('b-list-warn-place-phrases-table', 'klient', 'Клиент'),
                                    transformData: function(rowData) {
                                        return {
                                            block: 'b-list-warn-place-phrases-table',
                                            elem: 'fio',
                                            content: {
                                                block: 'link',
                                                url: u.getUrl('showCamps', {
                                                    ulogin: rowData.login
                                                }),
                                                content: rowData.fio
                                            }
                                        };
                                    }
                                },
                                {
                                    key: 'login',
                                    title: iget2('b-list-warn-place-phrases-table', 'login', 'Логин'),
                                    transformData: function(rowData) {
                                        return {
                                            block: 'b-list-warn-place-phrases-table',
                                            elem: 'login',
                                            content: {
                                                block: 'link',
                                                url: u.getUrl('showCamps', {
                                                    ulogin: rowData.login
                                                }),
                                                content: rowData.login
                                            }
                                        };
                                    }
                                }
                            ],
                            {
                                key: 'addtime',
                                title: iget2('b-list-warn-place-phrases-table', 'dobavlena', 'Добавлена'),
                                transformData: function(rowData) {
                                    return rowData.addtime_format;
                                }
                            }
                        ]),
                        rows: data.phrases,
                        mixes: {
                            row: [{
                                block: 'b-style-table',
                                elem: 'row'
                            }],
                            headerRow: [{
                                block: 'b-style-table',
                                elem: 'head'
                            }],
                            cell: [{
                                block: 'b-style-table',
                                elem: 'cell'
                            }],
                            headerCell: [{
                                block: 'b-style-table',
                                elem: 'cell'
                            }]
                        }
                    }
                }
            ]
        };
    })
);
