BEM.DOM.decl({ block: 'b-list', modName: 'style', modVal: 'expandable' }, {

    onSetMod: {

        js: function() {
            this._limit = this.elemInstance('list').params.limit;

            this._collapse = this.elemInstance('collapse');
            this._expand = this.elemInstance('expand');

            this.elem('item').length <= this._limit && this.expand();

            this
                .bindTo('expand', 'click', this.expand)
                .bindTo('collapse', 'click', this.collapse);
        }

    },

    /**
     * Раскрывает список
     */
    expand: function() {
        this._collapse && this._collapse.delMod('hidden');
        this._expand && this._expand.setMod('hidden', 'yes');

        this
            .elemInstances('item', 'hidden', 'yes')
            .forEach(function(block) { block.delMod('hidden') });
    },

    /**
     * Скрывает список
     */
    collapse: function() {
        this._expand && this._expand.delMod('hidden');
        this._collapse && this._collapse.setMod('hidden', 'yes');

        this
            .elemInstances('item')
            .slice(this._limit)
            .forEach(function(block) { block.setMod('hidden', 'yes') });
    }

});
