BEM.DOM.decl('b-loader', {

    /**
     * Показать лоадер
     */
    show: function() {
        this._getPopup().show();
        this._getSpin().setMod('progress', 'yes');
    },

    /**
     * Спрятать лоадер
     */
    hide: function() {
        this._getPopup().hide();
        this._getSpin().delMod('progress');
    },

    /**
     * type {BEM.DOM}
     * @private
     */
    _popup: null,

    /**
     * Возвращает экземпляр блока `popup`
     * @returns {BEM.DOM}
     * @private
     */
    _getPopup: function() {
        return this._popup || (this._popup = this.findBlockOn('popup'));
    },

    /**
     * Устанавливает DOM-ноду в которую будет добавлен `popup`
     * @param {jQuery} scopeDomElem
     */
    setScope: function(scopeDomElem) {
        this._getPopup()._scope = scopeDomElem;
    },

    /**
     * type {BEM.DOM}
     * @private
     */
    _spin: null,

    /**
     * Возвращает инстанс блока `spin`
     * @returns {BEM.DOM}
     * @private
     */
    _getSpin: function() {
        return this._spin || (this._spin = this.findBlockInside('spin'));
    },

    /**
     * Удаляет блок
     */
    destruct: function() {
        this.__self._instance = this.__self._ownerUniqId = null;

        return this.__base.apply(this, arguments);
    }

}, {

    /**
     * type {BEM.DOM}
     * @private
     * @static
     */
    _instance: null,

    /**
     * type {BEM.DOM}
     * @private
     * @static
     */
    _ownerUniqId: null,

    /**
     * Возвращает инстанс блока `b-loader`
     * Если его нет - создаёт
     * @param {BEM.DOM} block экземпляр блока, куда нужно поместить загрузчик
     * @param {Object} [popupMods] Дополнительные модификатор для блока `popup`
     * @static
     * @returns {BEM.DOM}
     */
    getInstance: function(block, popupMods) {
        var uniqId = (block.params || {}).uniqId || $.identify(block);

        this._instance || (this._instance = $(BEMHTML.apply({
            block: 'popup',
            js: true,
            mods: $.extend({
                theme: 'custom',
                type: 'modal',
                autoclosable: 'no'
            }, popupMods),
            mix: [{ block: this.getName() }],
            underMods: { type: 'paranja', target: 'b-loader' },
            content: [{
                elem: 'content',
                content: {
                    block: 'spin',
                    js: true,
                    mods: { theme: 'white-48' }
                }
            }]
        })).bem(this.getName()));

        if (this._ownerUniqId !== uniqId) {
            this._instance.setScope(block.domElem);
            this._ownerUniqId = uniqId;
        }

        return this._instance;
    }

});
