block('b-mass-action-video-extension-popup')(
    js()(true),

    content()(function() {
        return [
            {
                elem: 'header',
                mix: { block: 'b-modal-popup-decorator', elem: 'header' }
            },
            {
                elem: 'body',
                creatives: this.ctx.creatives,
                mix: { block: 'b-modal-popup-decorator', elem: 'body' }
            },
            {
                elem: 'footer',
                mix: { block: 'b-modal-popup-decorator', elem: 'footer' },
                readonly: this.ctx.readonly
            }
        ];
    }),

    elem('header').content()(function() {
        return [
            {
                elem: 'header-text',
                mix: { block: 'b-modal-popup-decorator', elem: 'header-text' },
                content: [
                    iget2('b-mass-action-video-extension-popup', 'add-video-extension', 'Добавить видеодополнения'),
                    {
                        block: 'b-help-link',
                        mix: { block: 'b-user-settings', elem: 'help-icon' },
                        mods: { type: 'modal' },
                        url: u.getHelpUrl('video-extension')
                    }
                ]
            }
        ]
    }),

    elem('body').content()(function() {
        var creativesCount = (this.ctx.creatives || []).length;

        return [
            {
                block: 'dropdown2',
                mods: { switcher: 'button', theme: 'normal', size: 's', 'has-tick': 'yes' },
                switcher: iget2('b-mass-action-video-extension-popup', 'podobrat-na-osnove-tematiki', 'Подобрать на основе тематики'),
                mix: {
                    block: 'b-mass-action-video-extension-popup',
                    elem: 'extension-dropdown'
                },
                popup: {
                    block: 'popup2',
                    directions: ['bottom-left'],
                    zIndexGroupLevel: 6,
                    content: {
                        block: 'b-chooser',
                        mix: {
                            block: 'b-mass-action-video-extension-popup',
                            elem: 'extension-list'
                        },
                        mods: {
                            search: 'yes'
                        },
                        content: [
                            {
                                elem: 'search',
                                hint: iget2('b-mass-action-video-extension-popup', 'poisk', 'Искать')
                            },
                            {
                                elem: 'wrap',
                                js: {
                                    childrenCount: creativesCount + (creativesCount ? 2 : 1)
                                },
                                content: [
                                    {
                                        elem: 'item',
                                        js: {
                                            text: iget2('b-mass-action-video-extension-popup', 'podobrat-na-osnove-tematiki', 'Подобрать на основе тематики')
                                        },
                                        name: 'auto',
                                        elemMods: {
                                            selected: 'yes'
                                        },
                                        content: iget2('b-mass-action-video-extension-popup', 'podobrat-na-osnove-tematiki', 'Подобрать на основе тематики')
                                    },
                                    !!creativesCount && {
                                        elem: 'item',
                                        elemMods: {
                                            click: 'ignore'
                                        },
                                        mix: {
                                            block: 'b-mass-action-video-extension-popup',
                                            elem: 'exist-group'
                                        },
                                        content: iget2('b-mass-action-video-extension-popup', 'ranee-sozdannie-videodopolnenia', 'Ранее созданные видеодополнения')
                                    }
                                ].concat(this.ctx.creatives.map(function(item) {
                                    var extensionName = item.name + ' — ' + iget2('b-mass-action-video-extension-popup', 'id', 'ID') + item.id;

                                    return {
                                        elem: 'item',
                                        name: item.id,
                                        js: {
                                            text: extensionName
                                        },
                                        content: extensionName
                                    }
                                }))
                            },
                            { elem: 'not-found' }
                        ]
                    }
                }
            },
            {
                elem: 'legal-hint',
                content: iget2('b-mass-action-video-extension-popup', 'najimaia-ja-obiazyus', 'Нажимая на кнопку, я обязуюсь проверить созданные ролики для моих кампаний.')
            }
        ];
    }),

    elem('footer').content()(function() {
        var readonly = this.ctx.readonly;

        return [
            {
                block: 'button',
                mods: { theme: 'action', disabled: readonly ? 'yes' : 'no' },
                mix: [
                    { block: 'b-mass-action-video-extension-popup', elem: 'replace-button' },
                    { block: 'b-modal-popup-decorator', elem: 'footer-button' }
                ],
                content: iget2('b-mass-action-video-extension-popup', 'izmenit', 'Изменить')
            },
            {
                block: 'button',
                mods: { disabled: readonly ? 'yes' : 'no' },
                mix: [
                    { block: 'b-mass-action-video-extension-popup', elem: 'remove-button' },
                    { block: 'b-modal-popup-decorator', elem: 'footer-button' }
                ],
                content: iget2('b-mass-action-video-extension-popup', 'delete-all-extensions', 'Удалить все видеодополнения')
            },
            {
                block: 'button',
                mix: [
                    { block: 'b-mass-action-video-extension-popup', elem: 'decline-button' },
                    { block: 'b-modal-popup-decorator', elem: 'footer-button' }
                ],
                content: iget2('b-mass-action-video-extension-popup', 'otmena', 'Отмена')
            }
        ]
    })
);
