BEM.DOM.decl({ block: 'b-mass-action-video-extension-popup', implements: 'i-modal-popup-inner-block-interface' }, {
    onSetMod: {
        js: function() {
            this._subMan = BEM.create('i-subscription-manager');

            u.graspSelf.call(this, {
                _replace: '? button on replace-button',
                _remove: '? button on remove-button',
                _cancel: 'button on decline-button',
                _videoExtensionList: '? b-chooser on extension-list',
                _extensionDrop: '? dropdown2 on extension-dropdown'
            });

            this._initActions();
        },

        processing: function(modName, modVal) {
            this._toggleButtonsState(true, modVal == 'yes');
            // событие, чтобы изменить состояние крестика на попапе
            this.trigger('buttons-disabled', { disabled: modVal == 'yes' });
        }
    },

    /**
     * Были ли изменения
     * @returns {Promise}
     * @private
     */
    isChanged: function() {
        var deferred = $.Deferred();

        // заглушка на будущие доработки
        deferred.resolve(false);

        return deferred;
    },

    /**
     * Инициализация общих обработчиков
     * @private
     */
    _initActions: function() {
        this._subMan
            .on(this._replace, 'click', function() {
                var rawVal = this._videoExtensionList.val(),
                    val = rawVal === 'auto' ? '' : rawVal;

                this.setMod('processing', 'yes');
                this.trigger('replace', val);
            }, this)
            .on(this._remove, 'click', function() {
                this.setMod('processing', 'yes');
                this.trigger('remove');
            }, this)
            .on(this._cancel, 'click', function() {
                this.trigger('cancel');
            }, this)
            .on(this._videoExtensionList, 'change', function() {
                this._extensionDrop.delMod('opened');
                this._extensionDrop.getSwitcher().setText(this._videoExtensionList.getSelected().text);
            }, this);
    },

    /**
     * Смена состояния кнопок
     * @param {Boolean} state - состояние контрола ввода счетчиков
     * @param {Boolean} isProcessing - флаг, что снаружи происходит сохранение
     * @private
     */
    _toggleButtonsState: function(state, isProcessing) {
        this._replace.toggleMod('disabled', '', 'yes', state && !isProcessing);
        this._remove.toggleMod('disabled', '', 'yes', state && !isProcessing);
        this._cancel.toggleMod('disabled', '', 'yes', !isProcessing);
    }

});
