(function() {

    var blankTargets = ['sendOptimize', 'copyBannersToMediaplan', 'multieditMediaplan', 'multicopyMediaplan'],
        cmdValues = {
            delete: 'deleteAdGroup',
            copyMcbanner: 'copyMediaAdGroups',
            copyCpmBanner: 'copyAdGroupsCpmBanner',
            copyContentPromotion: 'copyAdGroupsContentPromotion',
            stop: 'stopAdGroup',
            resume: 'resumeAdGroup',
            sendBK: 'admSendBK',
            sendMD: 'admSendMD',
            sendMDCallouts: 'remoderateBannersAdditions',
            moderateAcceptCallouts: 'moderateAcceptBannersAdditions',
            archive: 'archiveBanner',
            unarchive: 'unarchiveBanner'
        },
        cmdMobileContentValues = {
            delete: 'deleteAdGroup',
            stop: 'stopAdGroup',
            resume: 'resumeAdGroup',
            sendBK: 'admSendBK',
            sendMD: 'admSendMD',
            sendMDCallouts: 'remoderateBannersAdditions',
            archive: 'archiveBanner',
            unarchive: 'unarchiveBanner'
        },

        confirms = {
            delete: iget2('b-mass-actions', 'vy-deystvitelno-hotite-udalit', 'Вы действительно хотите удалить группы?'),
            multidelMediaplan: iget2('b-mass-actions', 'vy-deystvitelno-hotite-udalit-102', 'Вы действительно хотите удалить блок?'),
            sendMD: iget2(
                'b-mass-actions',
                'vy-deystvitelno-hotite-otpravit',
                'Вы действительно хотите отправить выбранные группы заново на модерацию?'
            ),
            sendMDCallouts: iget2(
                'b-mass-actions',
                'vy-deystvitelno-hotite-otpravit-103',
                'Вы действительно хотите отправить на перемодерацию все уточнения, привязанные к объявлениям в выбранных группах?'
            ),
            sendModerate: iget2(
                'b-mass-actions',
                'vy-deystvitelno-hotite-otpravit-104',
                'Вы действительно хотите отправить выбранные группы на модерацию?'
            ),
            clientSendModerate: iget2(
                'b-mass-actions',
                'vy-deystvitelno-hotite-otpravit-104',
                'Вы действительно хотите отправить выбранные группы на модерацию?'
            ),
            moderateAccept: iget2('b-mass-actions', 'vy-deystvitelno-hotite-prinyat', 'Вы действительно хотите ПРИНЯТЬ группы БЕЗ модерации?'),
            moderateAcceptCallouts: iget2(
                'b-mass-actions',
                'vy-deystvitelno-hotite-prinyat-105',
                'Вы действительно хотите ПРИНЯТЬ все уточнения, привязанные к группе БЕЗ модерации?'
            ),
            stopAndRemoderateBanner: iget2(
                'b-mass-actions',
                'vy-deystvitelno-hotite-ostanovit',
                'Вы действительно хотите ОСТАНОВИТЬ и ПЕРЕМОДЕРИРОВАТЬ выбранные группы?'
            )
        };

    BEM.DOM.decl({ block: 'b-mass-actions', modName: 'type', modVal: 'camp' }, {
        onSetMod: {
            js: function() {
                this.__base.apply(this, arguments);

                var formParams = this.params.form;

                this.formRequest = BEM.create({ block: 'i-request', mods: { type: 'form' } }, {
                    url: formParams.action,
                    type: formParams.method,
                    name: formParams.name,
                    target: formParams.target
                });
            }
        },

        _getCmdByMediaType: function(mediaType) {
            var action = this._action,
                editActions = [
                    'edit',
                    'editDynamic',
                    'editPerformance',
                    'editMcbanner',
                    'editCpmBanner',
                    'editContentPromotion'
                ],
                copyActions = [
                    'copy',
                    'copyDynamic',
                    'copyPerformance'
                ];

            if (editActions.indexOf(action) !== -1 || copyActions.indexOf(action) !== -1) {
                return u.campaign.getEditCmdByMediaType(mediaType);
            }

            if (mediaType === 'mobile_content') {
                return cmdMobileContentValues[action];
            }

            return cmdValues[action] || action;
        },

        _onSubmit: function() {
            this.__base.apply(this, arguments);

            var availableModelIds = this._getAvailableKeys(this._keys, this._action),
                campModel = BEM.MODEL.getOrCreate(this.params.modelParams),
                cmd = this._action,
                mediaType = campModel.get('mediaType'),
                useBanner = mediaType === 'mcbanner' || mediaType === 'performance',
                overflow,
                params = {},
                attrs = {},
                groupModels = availableModelIds.map(function(id) {
                    return campModel.getChildGroupById(id);
                }),
                bannersForEditCountLimited,
                dnaLimit = 50,
                bannersEditLimit = cmd === 'editBannersNew' ? dnaLimit : u.consts('MAX_OPEN_FOR_EDIT_BANNERS'),
                bannersForEditCount = groupModels.reduce(function(prev, curr) {
                    var bannersCount = curr.get('edit_banners_quantity');
                    if (bannersCount === undefined) {
                        bannersCount = curr.get('banners_quantity'); // в смартах нет edit_banners_quantity - считаем все баннеры
                    }
                    var res = prev + bannersCount;

                    // DIRECT-39077 вычисляем количество баннеров вписывающееся в ограничение, и не разрезающее группу
                    if (!bannersForEditCountLimited && res > bannersEditLimit) {
                        bannersForEditCountLimited = prev;
                    }

                    return res;
                }, 0),
                groupParams = this._params.items;

            if (this.params.newCopyAllowed && cmd === 'copy') {
                if (availableModelIds.length > dnaLimit) {
                    BEM.blocks['b-user-dialog'].alert(
                        iget2('b-mass-actions', 'too-much-groups-to-copy', 'Одновременно можно скопировать не более {limit} групп', {
                            limit: dnaLimit
                        })
                    );
                    return;
                }

                this.findBlockOn(this.elem('button'), 'button').setMod('disabled', 'yes');
                return this.trigger('newCopy', availableModelIds);
            }

            if (cmd === 'moderateAccept') {
                var isOutdoorSelected = this._isSelectedGroup('cpm_outdoor'),
                    isIndoorSelected = this._isSelectedGroup('cpm_indoor'),
                    isFrontpageSelected = this.params.campaignType === 'cpm_yndx_frontpage';

                if (
                    isOutdoorSelected ||
                    isIndoorSelected
                ) {
                    confirms[cmd] = iget2(
                        'b-mass-actions',
                        'gruppi-indoor-i-outdoor-budut-moderirovatsya',
                        'Вы действительно хотите ПРИНЯТЬ группы БЕЗ модерации?</br> Группы следующих типов БУДУТ модерироваться: {outdoor} {indoor}',
                        {
                            outdoor: isOutdoorSelected ? iget2('b-mass-actions', 'outdoor', '<br/> - Наружная реклама') : '',
                            indoor: isIndoorSelected ? iget2('b-mass-actions', 'indoor', '<br/> - Внутренняя реклама') : '',
                        }
                    )
                } else if (isFrontpageSelected) {
                    confirms[cmd] = iget2(
                        'b-mass-actions',
                        'gruppi-mediynoy-campanii-na-glavnoy-budut-moderirovatsya',
                        'Вы действительно хотите ПРИНЯТЬ группы БЕЗ модерации?</br> Группы рекламы на главной странице БУДУТ модерироваться.'
                    )
                } else {
                    confirms[cmd] = iget2('b-mass-actions', 'vy-deystvitelno-hotite-prinyat', 'Вы действительно хотите ПРИНЯТЬ группы БЕЗ модерации?')
                }
            }

            if ([
                'edit',
                'editBannersNew',
                'editDynamic',
                'editPerformance',
                'editMcbanner',
                'editCpmBanner'
            ].indexOf(cmd) !== -1) {
                // DIRECT-39077 если на редактирование попытаются открыть слишком много баннеров -- предупреждаем, что откроются не все
                if (bannersForEditCount > bannersEditLimit) {
                    confirms[cmd] = useBanner ?
                        iget2(
                            'b-mass-actions',
                            'odnovremenno-redaktirovat-mozhno-do',
                            'Одновременно редактировать можно до {foo} баннеров. Вы хотите продолжить работу с первыми {bar} из {baz} выбранных баннеров?',
                            {
                                foo: bannersEditLimit,
                                bar: bannersForEditCountLimited,
                                baz: bannersForEditCount
                            }
                        ) :
                        iget2(
                            'b-mass-actions',
                            'odnovremenno-redaktirovat-mozhno-do-106',
                            'Одновременно редактировать можно до {foo} объявлений. Вы хотите продолжить работу с первыми {bar} из {baz} выбранных объявлений?',
                            {
                                foo: bannersEditLimit,
                                bar: bannersForEditCountLimited,
                                baz: bannersForEditCount
                            }
                        );
                }

                if (cmd === 'editCpmBanner' && this._isSelectedGroup('cpm_indoor') && this._isSelectedGroup('cpm_outdoor')) {
                    confirms[cmd] = iget2(
                        'b-mass-actions',
                        'edit-warning-cpm-outdoor-and-indoor-groups',
                        'Массовое редактирование для групп с типами: «Наружная реклама» и «Внутренняя реклама» не поддерживается.</br>На редактирование откроются другие типы групп.'
                    );
                } else if (cmd === 'editCpmBanner' && this._isSelectedGroup('cpm_outdoor')) {
                    confirms[cmd] = iget2(
                        'b-mass-actions',
                        'edit-warning-cpm-dooh-group',
                        'Массовое редактирование для групп с типом «Наружная реклама» не поддерживается.</br>На редактирование откроются другие типы групп.'
                    );
                } else if (cmd === 'editCpmBanner' && this._isSelectedGroup('cpm_indoor')) {
                    confirms[cmd] = iget2(
                        'b-mass-actions',
                        'edit-warning-cpm-indoor-group',
                        'Массовое редактирование для групп с типом «Внутренняя реклама» не поддерживается.</br>На редактирование откроются другие типы групп.'
                    );
                }
            }

            if (u._.contains(['copy', 'copyDynamic', 'copyPerformance', 'copyMcbanner', 'copyCpmBanner'], cmd)) {
                /*jshint -W007*/
                overflow = availableModelIds.length + +this.params.bannersCount - this.params.bannersLimit;
                if (overflow > 0) {
                    this._getConfirm().alert(useBanner ?
                        iget2(
                            'b-mass-actions',
                            'vnimanie-v-rezultate-kopirovaniya',
                            'Внимание! В результате копирования ограничение в {foo} баннеров будет превышено на {bar}. Необходимо уменьшить количество копируемых баннеров.',
                            {
                                foo: this.params.bannersLimit,
                                bar: overflow
                            }
                        ) :
                        iget2(
                            'b-mass-actions',
                            'vnimanie-v-rezultate-kopirovaniya-107',
                            'Внимание! В результате копирования ограничение в {foo} объявлений будет превышено на {bar}. Необходимо уменьшить количество копируемых объявлений.',
                            {
                                foo: this.params.bannersLimit,
                                bar: overflow
                            }
                        )
                    );
                    return;
                }

                if (cmd === 'copyCpmBanner' && this._isSelectedGroup('cpm_indoor') && this._isSelectedGroup('cpm_outdoor')) {
                    confirms[cmd] = iget2(
                        'b-mass-actions',
                        'copy-warning-cpm-outdoor-and-indoor-groups',
                        'Массовое копирование для групп с типами: «Наружная реклама» и «Внутренняя реклама» не поддерживается.</br>Будут скопированы другие типы групп.'
                    );
                } else if (cmd === 'copyCpmBanner' && this._isSelectedGroup('cpm_outdoor')) {
                    confirms[cmd] = iget2(
                         'b-mass-actions',
                         'copy-warning-cpm-dooh-group',
                         'Массовое копирование для групп с типом «Наружная реклама» не поддерживается.</br>Будут скопированы другие типы групп.'
                     );
                } else if (cmd === 'copyCpmBanner' && this._isSelectedGroup('cpm_indoor')) {
                    confirms[cmd] = iget2(
                        'b-mass-actions',
                        'copy-warning-cpm-indoor-group',
                        'Массовое копирование для групп с типом «Внутренняя реклама» не поддерживается.</br>Будут скопированы другие типы групп.'
                    );
                }

            }

            if (['editAgeLabels', 'editChildAgeLabels', 'setAutotargeting'].indexOf(cmd) !== -1)
                return this.trigger(cmd, groupModels.map(function(model) {
                    return model.get('modelId');
                }));

            if (cmd === 'editTags')
                return this.trigger(cmd, availableModelIds);

            params.adgroup_ids = availableModelIds.join(',');

            if (u._.contains([
                'edit',
                'editBannersNew',
                'editMcbanner',
                'copyMcbanner',
                'copy',
                'editDynamic',
                'copyDynamic',
                'editPerformance',
                'copyPerformance',
                'editCpmBanner',
                'copyCpmBanner'
            ], cmd)) {
                params.bid = availableModelIds.reduce(function(res, groupId) {
                    res.push.apply(res, (groupParams[groupId].bid || []).filter(Boolean));
                    return res;
                }, []).slice(0, bannersForEditCountLimited).join(',');

                if (cmd === 'editBannersNew' && params.bid === '' && availableModelIds.length > 1) {
                    BEM.blocks['b-user-dialog'].alert(iget2('b-mass-actions', 'select-groups-with-banners', 'В выбранных группах нет объявлений для редактирования'));
                    return;
                }
            }

            params.cmd = this._getCmdByMediaType(mediaType);

            if (u._.contains([
                'copy',
                'copyDynamic',
                'copyPerformance',
                'copyMcbanner',
                'copyCpmBanner',
                'copyContentPromotion'
            ], cmd)) {
                params['is_groups_copy_action'] = '1';
            }

            if (cmd === 'editGroupsNew') {
                if (availableModelIds.length > dnaLimit) {
                    confirms[cmd] = iget2(
                        'b-mass-actions',
                        'new-edit-groups-limit',
                        'Одновременно редактировать можно до {limit} групп. Вы хотите продолжить работу с первыми {limit} из {total} выбранных групп?',
                        {
                            limit: dnaLimit,
                            total: availableModelIds.length
                        }
                    );
                }
            }

            if (u._.contains([
                'editBannersNew',
                'editGroupsNew'
            ], cmd)) {
                var newEditCmdToPath = {
                    editBannersNew: '/dna/banners-edit',
                    editGroupsNew: '/dna/groups-edit'
                };

                attrs.url = newEditCmdToPath[cmd];
                attrs.type = 'GET';

                params = {
                    from_old_interface: '1',
                    'campaigns-ids': this.params.form.cid,
                    'banners-ids': params.bid,
                    'groups-ids': availableModelIds.slice(0, dnaLimit).join(',')
                };

                if (params['banners-ids'] === '') {
                    params['is-new'] = '1';
                }
            }

            var blankSubmit = function() {
                blankTargets.indexOf(cmd) !== -1 && (attrs.target = '_blank');
                this.submitForm(params, attrs);
            }.bind(this);

            if (confirms[cmd]) {
                this._getConfirm().open({
                    message: confirms[cmd],
                    onYes: blankSubmit
                });
            } else {
                blankSubmit();
            }
        },

        /**
         * Проверяет есть ли в выбранных группах переданный тип группы
         * @param {String} groupType
         * @returns {Boolean}
         * @private
         */
        _isSelectedGroup: function(groupType) {
            var campModel = BEM.MODEL.getOrCreate(this.params.modelParams);

            return campModel.get('selectedAdgroupIds').some(function(id) {
                return campModel.getChildGroupById(id).get('cpmGroupType') === groupType;
            });
        },

        /**
         * @override {b-mass-actions}
         */
        _getAvailableActions: function(key) {
            return this._params.items[key].options;
        },

        /**
         * Отфильтровывает из массива keys те, для которых доступно действие actionName
         * @param {Array} keys
         * @param {String} actionName
         * @returns {Array}
         * @private
         */
        _getAvailableKeys: function(keys, actionName) {
            //fix DIRECT-39172
            if (actionName == 'edit' || actionName == 'copy') return keys;

            return keys.filter(function(key) {
                return this._params.items[key] && this._params.items[key].options[actionName];
            }, this);
        },

        submitForm: function(params, attrs) {
            this.formRequest.submit($.extend({}, this.params.form.params, params), attrs);
        }
    });

})();
