block('b-mass-actions').mod('type', 'camps').js()(function() {
    var data = this.data,
        campsGroups = this.campsGroups,
        currency = data.work_currency,
        rights = data.login_rights,
        accessToFav = rights.is_any_client || rights.super_control || rights.agency_control ||
        rights.manager_control,
        accessToPayment = u.consts('domains').ru && ((rights.role == 'client' && !rights.client_have_agency) ||
            rights.super_control || rights.manager_control || rights.support_control) && (currency == 'YND_FIXED' ||
            currency == 'RUB'),
        massActionsValues = this.massActions.values,
        favCamps = data.favorite_camps || {},
        items = {},
        itemsType = {},
        brandLiftCamps = [];

    this.campsGroupsKeys.forEach(function(groupId) {
        var campsGroup = campsGroups[groupId];

        campsGroup.camps.forEach(function(camp) {
            var cid = camp.cid,
                campAction = camp.action,
                actions = {};

            for (var action in campAction) {
                if (campAction.hasOwnProperty(action) && massActionsValues[action]) {
                    actions[action] = 1;
                }
            }

            accessToFav && (actions[favCamps[cid] ? 'unFavoriteCamp' : 'favoriteCamp'] = 1);

            accessToPayment && camp.action && camp.action.pay &&
                camp.statusPostModerate == 'Accepted' && (actions['directPaymentInstructions'] = 1);

            items[cid] = actions;
            itemsType[cid] = camp.mediaType;

            if (camp.brand_survey_id) {
                brandLiftCamps.push(cid)
            }
        });
    });

    return {
        items: items,
        itemsType: itemsType,
        brandLiftCamps: brandLiftCamps,
        isAutoVideoFlagOn: !!data.auto_video,
        ulogin: u.consts('ulogin'),
        csrf_token: this['i-global'].csrf_token,
        metrikaCounters: data.common_metrika_counters,
        readonly: rights.superreader_control || rights.limited_support_control
    };
});
