BEM.DOM.decl({ block: 'b-mass-actions', modName: 'type', modVal: 'camps' }, {
    onSetMod: {

        js: function() {
            this.__base.apply(this, arguments);

            this._subMan = BEM.create('i-subscription-manager');
        }
    },

    /**
     * Сообщение, что некоторые кампании не могут совершить действие
     * @param {Function} [callback] - функция, которую нужно выполнить после проверки
     */
    notifyItemsWithoutAction: function(callback) {
        var sortedAction = this._sortByType(this._action, this._keys),
            withoutAction = sortedAction.withoutAction;

        !callback && (callback = (function() {
            this.checkBeforeSubmit(sortedAction.withAction);
        }).bind(this));

        if (withoutAction.length) { //notifyItemsWithoutAction
            var itemsWithoutActions = [];

            withoutAction.forEach(function(cid) {
                itemsWithoutActions.push(this._getCampaignModel(cid).get('name') + ' (№ ' + cid + ')')
            }, this);

            this._getConfirm().open({
                limited: true,
                title: iget2('b-mass-actions', 'vybrannoe-deystvie-nedostupno-dlya', 'Выбранное действие недоступно для кампаний:') + ' ',
                message: itemsWithoutActions,
                question: iget2('b-mass-actions', 'prodolzhit', 'Продолжить?'),
                onYes: function() {
                    this.afterCurrentEvent(callback);
                }
            }, this);

        } else {
            callback();
        }
    },

    /**
     * Попап подтверждения необратимых действий
     * @param {Array} withAction - список cid-ов кампаний
     */
    checkBeforeSubmit: function(withAction) {
        var message,
            action = this._action,
            brandLiftCampsStop = this._action === 'stopCamp' ?
                u._.intersection(this.params.brandLiftCamps, withAction) :
                [];

        switch (action) {
            case 'delCamp':
                message = iget2('b-mass-actions', 'vy-uvereny-chto-hotite', 'Вы уверены, что хотите удалить выбранные кампании?');
                break;
            case 'remoderateCamp':
                message = iget2('b-mass-actions', 'vy-uvereny-chto-hotite-108', 'Вы уверены, что хотите ПЕРЕМОДЕРИРОВАТЬ выбранные кампании?');
                break;
            default:
                message = null;
                break;
        }

        if (message) {
            this._getConfirm().open({
                limited: true,
                message: message,
                onYes: function() {
                    this.submitForm(withAction);
                }
            }, this);
        } else if (brandLiftCampsStop.length) {
            this._getConfirm().open({
                limited: true,
                title: iget2('b-mass-actions', 'brand-lift-camps-stop-header', 'Исследование Brand Lift проводится в кампаниях:') + ' ',
                message: brandLiftCampsStop.map(function(cid) {
                    return this._getCampaignModel(cid).get('name') + ' (№ ' + cid + ')';
                }, this),
                question: iget2('b-mass-actions', 'brand-lift-camps-stop-footer', 'Не останавливайте эти кампании досрочно — собранных данных может оказаться недостаточно для достоверных выводов'),
                textYes: iget2('b-mass-actions', 'yes', 'Остановить'),
                textNo: iget2('b-mass-actions', 'no','Отменить'),
                onYes: function() {
                    this.submitForm(withAction);
                }
            }, this);
        } else {
            this.submitForm(withAction);
        }
    },

    /**
     * Отправка запроса
     * @param {Array} withAction - список cid-ов кампаний
     * @param {Object} extraParams - дополнительные параметры
     */
    submitForm: function(withAction, extraParams) {
        var action = this._action,
            params = {
                cmd: action,
                cid: withAction,
                ulogin: this._params.ulogin,
                csrf_token: this._params.csrf_token
            },
            self = this;

        u._.extend(params, extraParams);

        BEM.blocks['b-metrika2'].params({
            params: {
                ShowCamps: {
                    massAction: action
                }
            }
        });

        if (action == 'copyCampClient') {
            BEM.blocks['i-campaign'].copyCamps(withAction, u.consts('ulogin'))
                .then(function(result) {
                    BEM.blocks['b-confirm'].alert(result.message);
                })
                .fail(function() {
                    BEM.blocks['b-confirm'].alert(iget2('b-mass-actions', 'ne-udalos-skopirovat-kampanii', 'Не удалось скопировать кампании'));
                });

            return;
        }

        if (action == 'showCampStat') {
            params.cid = withAction.join(', ');
            params.stat_type = 'mol';
            params.cmd = 'showStat';
        }

        if (action === 'directPaymentInstructions') {
            var cidByPayType = withAction.reduce(function(result, cid) {

                if (self._params.itemsType[cid] === 'cpm_deals') {
                    result.cpmDeals.push(cid);
                } else if (self._params.itemsType[cid] === 'cpm_banner') {
                    result.cpmBanner.push(cid);
                } else if (self._params.itemsType[cid] === 'cpm_yndx_frontpage') {
                    result.cpmYndxFrontpage.push(cid);
                } else {
                    result.clicks.push(cid);
                }

                return result;
            }, { cpmBanner: [], cpmDeals: [], cpmYndxFrontpage: [], clicks: [] });

            if (
                cidByPayType.cpmDeals.length &&
                (cidByPayType.clicks.length || cidByPayType.cpmYndxFrontpage.length || cidByPayType.cpmBanner.length)
            ) {
                BEM.blocks['b-confirm'].alert(
                    iget2('b-mass-actions', 'pay-not-allowed-deals', 'Для оплаты кампаний со сделками необходимо выставить отдельный счет. Оплата вместе с кампаниями без сделок недоступна.')
                );
                return;
            } else if (
                (cidByPayType.cpmBanner.length || cidByPayType.cpmYndxFrontpage.length) && cidByPayType.clicks.length
            ) {
                BEM.blocks['b-confirm'].alert(
                    iget2('b-mass-actions', 'pay-not-allowed-cpm', 'Для оплаты медийных кампаний необходимо выставить отдельный счет. Оплата вместе с другими кампаниями недоступна.')
                );
                return;
            }
        }

        BEM.create({ block: 'i-request', mods: { type: 'form' } }, {
            url: '/registered/main.pl',
            type: action == 'showCampStat' ? this._getCampStatAction() : 'POST'
        }).submit(params);
    },

    /**
     * Деструктор
     */
    destruct: function() {
        this._subMan.dispose();

        this.__base.apply(this, arguments);
    },

    /**
     * Список названий моделей кампаний
     */
    _campModelNames: {
        text: 'm-campaign',
        mobile_content: 'dm-mobile-content-campaign',
        dynamic: 'm-campaign',
        performance: 'dm-dynamic-media-campaign',
        mcbanner: 'm-campaign',
        cpm_banner: 'dm-cpm-banner-campaign',
        cpm_yndx_frontpage: 'dm-cpm-yndx-frontpage-campaign',
        cpm_deals: 'dm-cpm-deals-campaign',
        cpm_price: 'dm-cpm-price-campaign'
    },

    /**
     * Получение модели кампании по cid-у
     * @param {String} cid - идентификатор кампании
     * @returns {BEM.MODEL}
     * @private
     */
    _getCampaignModel: function(cid) {
        var mediaType = this.params.itemsType[cid],
            modelName = this._campModelNames[mediaType] || 'm-campaign';

        return BEM.MODEL.getOne({ name: modelName, id: cid })
    },

    /**
     * Обработчик кнопки "Выполнить"
     * @private
     */
    _onSubmit: function() {
        this.__base.apply(this, arguments);

        if (this._action === 'ajaxSetAutoResources') {
            this.notifyItemsWithoutAction(this._openVideoExtensionPopup.bind(this));
        } else if (this._action === 'editMetrikaCounters') {
            this._openMetrikaPopup();
        } else {
            this.notifyItemsWithoutAction();
        }
    },

    /**
     * Открывает окно подтверждения включения/выключения видеодополнения для баннеров кампаний
     */
    _openVideoExtensionPopup: function() {
        var videoManager = BEM.create('i-mass-action-video-extension', {
            cids: this._sortByType(this._action, this._keys).withAction.join(', '),
            readonly: this.params.readonly
        });

        this._subMan.on(videoManager, 'closed', function() {
            videoManager.destruct();
            this._getButton().delMod('disabled');
        }, this);

        this._getButton().setMod('disabled', 'yes');
        videoManager.openPopup();
    },

    /**
     * Попап добавления счетчиков метрики
     * @private
     */
    _openMetrikaPopup: function() {
        var cids = this._sortByType(this._action, this._keys),
            affectedCids = cids.withAction,
            unAffectedCids = cids.withoutAction,
            performanceCids = u._.filter(affectedCids, function(cid) {
                return this.params.itemsType[cid] == 'performance'
            }, this),
            metrikaManager = BEM.create('i-mass-action-metrika-counters', {
                affectedCids: affectedCids,
                unAffectedCids: unAffectedCids,
                performanceCids: performanceCids,
                defaultCounter: this.params.metrikaCounters,
                readonly: this.params.readonly
            });

        this._subMan.on(metrikaManager, 'closed', function() {
            metrikaManager.destruct();
            this._getButton().delMod('disabled');
        }, this);

        this._getButton().setMod('disabled', 'yes');
        metrikaManager.openPopup();
    }
});
