block('b-mass-actions').mod('type', 'clients').js()(function() {
    var data = this.data,
        cmd = u.consts('cmd'),
        subClients = cmd == 'showClients',
        clients = (data[subClients ? 'subclients' : 'dc_list'] || []),
        access = hasLoginRights('super_control', 'manager_control', 'support_control', 'agency_control'),
        items = {},
        params = {
            ulogin: u.consts('ulogin'),
            csrf_token: this['i-global'].csrf_token,
            statType: subClients ? 'by_agency_clients' : 'by_clients',
            clientsCount: clients.length,
            directCmd: cmd
        };

    cmd == 'showClients' && (params.agencyClientList = 1);

    clients.forEach(function(client) {
        var actions = {};

        subClients && (actions['showSubClientCamps'] = 1);

        client.shows > 0 && (actions['showCampStat'] = 1);

        if (access) {
            if (client.is_archived) {
                actions['unArchiveUser'] = 1;
            } else {
                client.total < u.currencies.getConst(client.currency, 'MAX_CLIENT_ARCHIVE') &&
                    (actions['archiveUser'] = 1);
            }
        }

        items[client.login] = actions;
    });

    params.items = items;

    return params;
});
