(function() {

    var MAX_COUNT_FOR_OPERATION = 100;

    BEM.DOM.decl({ block: 'b-mass-actions', modName: 'type', modVal: 'clients' }, {

        _onSubmit: function() {
            this.__base.apply(this, arguments);

            this.notifyItemsWithoutAction();
        },

        notifyItemsWithoutAction: function() {
            var sortedAction = this._sortByType(this._action, this._keys),
                withoutAction = sortedAction.withoutAction;

            if (withoutAction.length) {
                this._getConfirm().open({
                    limited: true,
                    title: iget2('b-mass-actions', 'vybrannoe-deystvie-nedostupno-dlya-109', 'Выбранное действие недоступно для клиентов:') + ' ',
                    message: withoutAction,
                    question: iget2('b-mass-actions', 'prodolzhit', 'Продолжить?'),
                    onYes: function() {
                        this.checkBeforeSubmit(sortedAction.withAction);
                    }
                }, this);
            } else {
                this.checkBeforeSubmit(sortedAction.withAction);
            }
        },

        checkBeforeSubmit: function(withAction) {
            if (withAction.length > MAX_COUNT_FOR_OPERATION) {
                this._getConfirm().open({
                    limited: true,
                    type: 'alert',
                    message: iget2('b-mass-actions', 'nelzya-vypolnit-deystvie-bolee', 'Нельзя выполнить действие более чем со {foo} клиентами.', {
                        foo: MAX_COUNT_FOR_OPERATION
                    })
                });
            } else {
                this.submitForm(withAction);
            }

        },

        submitForm: function(withAction) {
            var action = this._action,
                jsParams = this._params,
                params = {
                    cmd: action,
                    client_login: withAction
                };

            action == 'showSubClientCamps' && (params.stat_type = 'by_agency_clients');
            action == 'showCampStat' && (params.stat_type = jsParams.statType);

            if (action == 'archiveUser' || action == 'unArchiveUser') {
                var directCmd = jsParams.directCmd,
                    agencyClientList = jsParams.agencyClientList;

                params.cl_cnt = jsParams.clientsCount - withAction.length;
                directCmd && (params.rcmd = directCmd);
                agencyClientList && (params.agency_client_list = agencyClientList);
            }

            jsParams.ulogin && (params.ulogin = jsParams.ulogin);
            jsParams.csrf_token && (params.csrf_token = jsParams.csrf_token);

            BEM.create({ block: 'i-request', mods: { type: 'form' } }, {
                url: '/registered/main.pl',
                type: action == 'showCampStat' ? this._getCampStatAction() : 'POST'
            }).submit(params);
        }

    });

})();
