BEM.DOM.decl({ block: 'b-mass-actions', modName: 'type', modVal: 'stat-platform' }, {

    onSetMod: {
        js: function() {
            this.__base.apply(this, arguments);

            this._spin = this.findBlockOn('spin', 'spin');

            this._cid = this.params.cid;
            this._ulogin = this.params.ulogin;
            this._disabledItems = this.params.disabledItems || [];
            this._disableLimit = this.params.disableLimit || 1000;

            this._disabledVideo = this.params.videoDisabledItems || [];

            // TODO: DIRECT-99054 — расскоментировать для Аудио
            // this._disabledAudio = this.params.audioDisabledItems || [];
        }
    },

    _keysData: {},

    /**
     * Обновляет список групповых действий
     * @param {String[]|Number[]} keys ключи групповых действий
     * @param {Object} [data] опциональный хэш соответствий ключ - связанные с действием данные
     */
    updateActions: function(keys, data) {
        this._keysData = data;

        return this.__base.call(this, keys);
    },

    /**
     * Возвращает доступные действия.
     * Для блока с текущим модификатором разрешены все действия, поэтому метод полностью переопределен.
     * @param {String} [key]
     * @returns {Object}
     * @override
     * @private
     */
    _getAvailableActions: function(key) {
        var availableActions = {
            disable: true,
            enable: true
        };

        if (this.params.hasVideoBlackList) {
            availableActions['video-disable'] = true;
            availableActions['video-enable'] = true;
        }

        // TODO: DIRECT-99054 — расскоментировать для Аудио
        // if (this.params.hasAudioBlackList) {
        //     availableActions['audio-disable'] = true;
        //     availableActions['audio-enable'] = true;
        // }

        return availableActions;
    },

    /**
     * Обработчик клика на кнопке "выполнить".
     * Отправляет POST запрос, выполняющий выбранное для площадки действие.
     * @private
     */
    _onSubmit: function(e) {
        var action,
            disabledItems,
            disabledVideo,
            // TODO: DIRECT-99054 — расскоментировать для Аудио
            // disabledAudio,
            checkedPages,
            data;

        e.type === 'blackListEnable' || this.__base.apply(this, arguments);

        action = this._action;

        disabledItems = this._disabledItems.slice();
        disabledVideo = this._disabledVideo.slice();

        // TODO: DIRECT-99054 — расскоментировать для Аудио
        // disabledAudio = this._disabledAudio.slice();

        checkedPages = this._keys.reduce(function(res, index) {
            var page = this._keysData[index],
                normalized = page.replace(/^(www\.)(.*\.)/, '$2'),
                disabledItemIndex,
                items;

            if (/video/.test(action)) {
                items = disabledVideo;
            // } else if (/audio/.test(action)) {
                // items = disabledAudio;
            } else {
                items = disabledItems;
            }

            disabledItemIndex = items.indexOf(normalized);

            switch (this._action.replace(/video-|audio-/, '')) {
                case 'disable':
                    disabledItemIndex < 0 && items.push(normalized);

                    break;
                case 'enable':
                    disabledItemIndex < 0 || items.splice(disabledItemIndex, 1);

                    break;

                case 'all-enable':
                    [disabledVideo, disabledItems].forEach(function(items) {
                        var index = items.indexOf(normalized);

                        index < 0 || items.splice(index, 1);
                    });

                    break;
            }

            res[normalized] || (res[normalized] = {});

            res[normalized] = {
                bannerDisabled: !!~disabledItems.indexOf(normalized),
                videoDisabled: !!~disabledVideo.indexOf(normalized)
                // audioDisabled: !!~disabledAudio.indexOf(normalized)
            };

            return res;
        }.bind(this), {});

        this._getConfirm()
            .open({
                message: ({
                    disable: this.params.hasVideoBlackList ?
                        iget2('b-mass-actions', 'banner-disable-confirm', 'Вы уверены, что хотите запретить показы <strong>медийных баннеров</strong> на выбранных площадках?') :
                        iget2('b-mass-actions', 'vy-uvereny-chto-hotite-110', 'Вы уверены, что хотите запретить показы на выбранных площадках?'),
                    enable: this.params.hasVideoBlackList ?
                        iget2('b-mass-actions', 'banner-enable-confirm', 'Вы уверены, что хотите разрешить показы <strong>медийных баннеров</strong> на выбранных площадках?') :
                        iget2('b-mass-actions', 'vy-uvereny-chto-hotite-111', 'Вы уверены, что хотите разрешить показы на выбранных площадках?'),
                    'video-disable': iget2('b-mass-actions', 'video-disable-confirm', 'Вы уверены, что хотите запретить показы <strong>видео баннеров</strong> на выбранных площадках?'),
                    'video-enable': iget2('b-mass-actions', 'video-enable-confirm', 'Вы уверены, что хотите разрешить показы <strong>видео баннеров</strong> на выбранных площадках?'),
                    'all-enable': iget2('b-mass-actions', 'all-enable-confirm', 'Вы уверены, что хотите разрешить показы <strong>видео баннеров</strong> и <strong>медийных баннеров</strong> на выбранных площадках?')
                    // TODO: DIRECT-99054 — расскоментировать для Аудио
                    // 'audio-disable': iget2('b-mass-actions', 'vy-uvereny-chto-hotite-110', 'Вы уверены, что хотите запретить показы на выбранных площадках?'),
                    // 'audio-enable': iget2('b-mass-actions', 'vy-uvereny-chto-hotite-111', 'Вы уверены, что хотите разрешить показы на выбранных площадках?')
                })[action],
                onYes: function() {
                    if (!/video|audio/.test(action) && disabledItems.length > this._disableLimit) {
                        this
                            ._getConfirm()
                            .alert(iget2(
                                'b-mass-actions',
                                'prevysheno-maksimalno-dopustimoe-kolichestvo',
                                'Превышено максимально допустимое количество отключенных площадок'
                            ));

                        return;
                    }

                    data = {
                        action: action,
                        checkedPages: checkedPages,
                        disabledItems: disabledItems,
                        disabledVideo: disabledVideo
                        // TODO: DIRECT-99054 — расскоментировать для Аудио
                        // disabledAudio: disabledAudio
                    };

                    if (e.type === 'blackListEnable') {
                        data.index = this._keys[0];
                    }

                    this.trigger('before-execute');

                    this._spin.setMod('progress', 'yes');
                    this._getSelect().setMod('disabled', 'yes');
                    this._getButton().setMod('disabled', 'yes');

                    if (/all/.test(action)) {
                        this._setEnableLists(data);
                    } else {
                        // TODO: DIRECT-99054 — добавить для Аудио
                        /video/.test(action) ?
                            this._updateVideoList(data) :
                            this._updateBannerList(data);
                    }
                },
                onNo: function() {
                    this.trigger('error-execute');
                }
            }, this);
    },

    _getRequest: function(data) {
        return new Promise(function(resolve, reject) {
            BEM.create('i-request_type_ajax', {
                url: this.params.url,
                type: 'POST',
                dataType: 'json',
                cache: false,
                callbackCtx: this,
            })
                .get({
                    op: data.action,
                    cid: this._cid,
                    ulogin: this._ulogin,
                    cmd: 'setCampDontShowMulti',
                    pages_checked: u._.keys(data.checkedPages).join(',')
                },
                function(response) {
                    resolve(response);
                },
                function(err) {
                    reject(err);
                });
        }.bind(this));
    },

    _getRequestWebApi: function() {
        return this._requestWebApi || (this._requestWebApi = BEM.blocks['i-web-api-request'].disabledDomains);
    },

    /**
     * @param {Object} response
     * @param {Object} data
     * @param {String} data.action
     * @param {Object} data.checkedPages
     * @param {Array} data.disabledItems
     * @param {Array} data.disabledVideo
     * @param {Array} data.disabledAudio
     * @param {Function} callback
     * @private
     */
    _onResponse: function(response, data, callback) {
        this._getSelect().delMod('disabled');
        this._getButton().delMod('disabled');

        callback(response, data);

        this._spin.delMod('progress');
    },

    _setEnableLists: function(data) {
        data.action = 'enable';

        Promise
            .all([
                this._getRequest(data),
                this._getRequestWebApi().disableVideoDomains(this._ulogin, {
                    cid: this._cid,
                    domains: u._.keys(data.checkedPages),
                    disable: false
                })
            ])
            .then(function(responses) {
                this._onResponse(responses, data, this._onResponseLists.bind(this));
            }.bind(this))
            .catch(function() {
                this._onFail(iget2('b-mass-actions', 'default-error', 'Что-то пошло не так. Пропробуйте позже'));
            }.bind(this));
    },

    _onResponseLists: function(responses, data) {
        var banner = responses[0],
            video = responses[1],
            // TODO: DIRECT-99054 — расскоментировать для Аудио
            // audio = responses[2],
            bannerError = banner.error,
            videoError = video.success ? undefined : this._errorsMapper(u._.get(video, 'validation_result.errors')[0].code),
            audioError;

        if (!bannerError && video.success) {
            this._onSuccess(data);
        } else if (bannerError && videoError) {
            this._onFail([bannerError, videoError].join('</br></br>'));
        } else {
            if (bannerError) {
                delete data.disabledItems;
                u._.values(data.checkedPages)[0].bannerDisabled = true;
            }

            if (videoError) {
                delete data.videoError;
                u._.values(data.checkedPages)[0].videoDisabled = true;
            }

            // TODO: DIRECT-99054 — расскоментировать для Аудио
            // if (audioError) {
            //     delete data.audioError;
            //     u._.values(data.checkedPages)[0].audioDisabled = true;
            // }

            this._onSuccess(data);
            this._getConfirm().alert(bannerError || videoError || audioError);
        }
    },

    /**
     * Обновляет BlackList для баннеров
     * @param {Object} data
     * @param {String} data.action
     * @param {Object} data.checkedPages
     * @param {Array} data.disabledItems
     * @param {Array} data.disabledVideo
     * @param {Array} data.disabledAudio
     * @private
     */
    _updateBannerList: function(data) {
        this._getRequest(data).then(function(response) {
            this._onResponse(response, data, this._onResponseBanner.bind(this));
        }.bind(this));
    },

    _onResponseBanner: function(response, data) {
        if (response.error) {
            this._onFail(response.error);
        } else {
            this._onSuccess(data);
        }
    },

    /**
     * Обновляет BlackList для видео баннеров (cpm)
     * @param {String} data.action
     * @param {Object} data.checkedPages
     * @param {Array} data.disabledItems
     * @param {Array} data.disabledVideo
     * @param {Array} data.disabledAudio
     * @returns {Promise}
     * @private
     */
    _updateVideoList: function(data) {
        return this._getRequestWebApi()
            .disableVideoDomains(this._ulogin, {
                cid: this._cid,
                domains: u._.keys(data.checkedPages),
                disable: /disable/.test(data.action)
            })
            .then(function(response) {
                this._onResponse(response, data, this._onResponseVideo.bind(this));
            }.bind(this));
    },

    _onResponseVideo: function(response, data) {
        if (response.success) {
            this._onSuccess(data);
        } else {
            var validationErrors = u._.get(response, 'validation_result.errors'),
                errorCode = validationErrors ? validationErrors[0].code : response.code;

            this._onFail(this._errorsMapper(errorCode));
        }
    },

    /**
     * @param {String} code
     * @returns {String}
     * @private
     */
    _errorsMapper: function(code) {
        switch (code) {
            case 'CampaignDefectIds.Gen.WRONG_DISABLED_DOMAINS_LIMIT':
                return iget2(
                    'b-mass-actions',
                    'prevysheno-maksimalno-dopustimoe-kolichestvo',
                    'Превышено максимально допустимое количество отключенных площадок'
                );

            case 54:
                return iget2(
                    'b-mass-actions',
                    'error-no-rights',
                    'Нет прав для выполнения операции'
                );

            case 'default':
                return iget2(
                    'b-mass-actions',
                    'default-error',
                    'Что-то пошло не так. Пропробуйте позже'
                );
        }
    },

    /**
     * Отображение ошибок
     * @param {String} errors
     * @private
     */
    _onFail: function(errors) {
        this._getConfirm().alert(errors);

        this.trigger('error-execute');
    },

    /**
     * @param {Object} data
     * @param {String} data.action
     * @param {Object} data.checkedPages
     * @param {Array} data.disabledItems
     * @param {Array} data.disabledVideo
     * @param {Array} data.disabledAudio
     * @private
     */
    _onSuccess: function(data) {
        data.disabledItems && (this._disabledItems = data.disabledItems);
        data.disabledVideo && (this._disabledVideo = data.disabledVideo);

        // TODO: DIRECT-99054 — расскоментировать для Аудио
        //data.disabledAudio && (this._disabledAudio = data.disabledAudio);

        this.trigger('complete-execute', {
            checkedPages: data.checkedPages,
            index: data.index
        });
    },

    /**
     * @param {Event} e
     * @param {Object} data
     */
    updateBlackList: function(e, data) {
        this._keys = [data.index];
        this._action = data.action;
        this._keysData[data.index] = data.pageName;

        this._onSubmit(e);
    }

});
