block('b-mass-actions')(

    def()(function() {
        return applyNext({
            'ctx.defOptionValue': '',
            'ctx.defOptionText': this.ctx.defOption || iget2('b-mass-actions', 'vyberite-kampanii', 'Выберите кампании')
        });
    }),

    content()(function() {
        var massActions = this.massActions || this.ctx.massActions,
            options = [{
                elem: 'option',
                attrs: {
                    value: this.ctx.defOptionValue
                },
                content: this.ctx.defOptionText
            }],
            optionGroups = [],
            // 1 элемент - это "выберите кампании"
            optionsCount = 1;

        massActions.keys.forEach(function(action) {
            options.push({
                elem: 'option',
                attrs: {
                    value: action
                },
                content: massActions.values[action]
            });
            optionsCount++;
        });

        options = options.concat(optionGroups);

        return [
            {
                elem: 'caption',
                content: iget2('b-mass-actions', 'deystvie', 'Действие:')
            },
            {
                block: 'select',
                name: 'mass_cmd',
                js: {
                    elemPopupMods: { 'hide-disabled-item': 'yes' },
                    popupMods: { adaptive: 'yes' },
                    popupParams: { directions: 'top-left' },
                    // количество рядов надо передавать, чтобы правильно рассчитывалась визуальная высота селекта
                    // из-за "спрятанных" css-ом элементов количество видимых рядов не совпадает с
                    // количеством рядов в DOM. Если рядов больше дефолта, селект начинает считать высоту скриптом
                    // и попап разъезжается, поэтому передаем правильный дефолт
                    // Задача на рефакторинг https://st.yandex-team.ru/DIRECT-61441
                    rows: optionsCount
                },
                mods: {
                    disabled: 'yes',
                    from: 'floater'
                },
                mix: [{
                    block: 'b-mass-actions',
                    elem: 'select'
                }],
                content: [
                    {
                        block: 'button',
                        content: this.ctx.defOptionText
                    },
                    {
                        elem: 'control',
                        content: options
                    }
                ]
            },
            {
                block: 'button',
                mods: {
                    disabled: 'yes'
                },

                mix: [{
                    block: 'b-mass-actions',
                    elem: 'button'
                }],
                content: iget2('b-mass-actions', 'vypolnit', 'выполнить')
            }
        ];
    })
);
