(function() {

    var MAX_COUNT_FOR_OPERATION = 100;

    BEM.DOM.decl('b-mass-actions', {

        onSetMod: {

            js: function() {
                this._params = this.params;

                this._getButton().on('click', this._onSubmit, this);
            },

            disabled: function(modName, modVal) {
                if (modVal) {
                    this._getSelect().elem('option').eq(0).prop('disabled', false);
                    this._getSelect().val('').redraw();
                }

                this._getSelect().setMod('disabled', modVal);
                this._getButton().setMod('disabled', modVal);
            }

        },

        _params: null,

        _keys: [],

        /**
         * Выставляет доступными действия которые разрешены для переданных идентификаторов групп
         *
         * @param {Array} keys идентификаторы групп
         */
        updateActions: function(keys) {
            var currentActions = this._getEnabledActions(keys),
                select = this._getSelect(),
                allItems = select.elem('option'),
                activeItems = allItems.filter(function(i, option) {
                    return currentActions[option.value];
                }),
                activeItemsLength = activeItems.length,
                selectValue = this._getSelect().val(),
                items = (activeItemsLength ? activeItems : allItems),
                optGroups = select.elem('option-group'),
                disabledOptGroups;

            allItems.prop('disabled', true);
            activeItems.prop('disabled', false);

            // скрываем группы со всеми задизэйбленными опциями
            optGroups.prop('disabled', false);

            disabledOptGroups = optGroups.filter(function(index, groupItem) {
                var groupItemOptions = $(groupItem).find('option'),
                    disabledGroupItemOptions = groupItemOptions.filter(function(index, option) {
                        return $(option).prop('disabled');
                    });

                return disabledGroupItemOptions.length === groupItemOptions.length;
            });

            disabledOptGroups.prop('disabled', true);

            // Если выбран не достпуный пункт
            if (!items.toArray().some(function(item) { return $(item).attr('value') == selectValue })) {
                select.val(items.eq(0).attr('value')).redraw();
            }

            select.redraw(); // Нужно чтобы перерисовать попап
            this.setMod('disabled', activeItemsLength ? '' : 'yes');
            this._keys = keys;
        },

        /**
         * Возвращает метод отправки запроса для выполнения выбранного действия
         *
         * @returns {String}
         * @private
         */
        _getCampStatAction: function() {
            return this._sortByType(this._action, this._keys).withAction.length > 100 ? 'POST' : 'GET';
        },

        _select: null,

        /**
         * Возвращает блок select
         *
         * @returns {BEM}
         * @private
         */
        _getSelect: function() {
            return this._select || (this._select = this.findBlockOn('select', 'select'));
        },

        _button: null,

        /**
         * Возвращает блок button
         *
         * @returns {BEM}
         * @private
         */
        _getButton: function() {
            return this._button || (this._button = this.findBlockOn('button', 'button'));
        },

        /**
         * Возвращает список доступных действий для переданного id группы
         *
         * @param {String|Number} key id группы
         * @returns {Object} хеш где ключ - имя доступного действия, значение всегда true
         * @private
         */
        _getAvailableActions: function(key) {
            return this._params.items[key];
        },

        /**
         * Отфильтровывает из массива keys те, для которых доступно действие actionName
         * @param {Array} keys
         * @param {String} actionName
         * @returns {Array}
         * @private
         */
        _getAvailableKeys: function(keys, actionName) {
            return keys.filter(function(key) {
                return this._params.items[key] && this._params.items[key][actionName];
            }, this);
        },

        /**
         * Возвращает доступные действия для переданных идентификаторов групп
         *
         * @param {Array} keys идентификаторы групп
         * @returns {Object} хеш где ключ - имя доступного действия, значение всегда true
         * @private
         */
        _getEnabledActions: function(keys) {
            var actions = {};

            keys.forEach(function(id) {
                var availableActions = this._getAvailableActions(id);

                actions = Object.keys(availableActions).reduce(function(res, key) {
                    res[key] = res[key] || availableActions[key];

                    return res;
                }, actions);

            }, this);

            //alkaline@todo запрещать редактировать разные типы групп более общим механизмом
            if (actions.edit && actions.editDynamic) {
                delete actions.edit;
                delete actions.editDynamic;
            }
            if (actions.editText && actions.editTextDynamic) {
                delete actions.editText;
                delete actions.editTextDynamic;
            }

            return actions;
        },

        _confirm: null,

        /**
         * Возвращает блок b-confirm
         *
         * @returns {BEM}
         * @private
         */
        _getConfirm: function() {
            !this._confirm && (this._confirm = BEM.blocks['b-confirm']);

            return this._confirm;
        },

        _action: null,

        /**
         * Возвращает объект с полями withAction и withoutAction
         * В полях собраны массивы идентификаторов групп у которых разрешен или запрешен переданный action
         *
         * @param {String} action действие
         * @param {Array} keys массив идентификаторов групп
         * @returns {Object}
         * @private
         */
        _sortByType: function(action, keys) {
            var result = {
                withAction: [],
                withoutAction: []
            };

            keys.forEach(function(key) {

                result[this._getAvailableActions(key)[action] ? 'withAction' : 'withoutAction'].push(key);
            }, this);

            return result;
        },

        /**
         * Запоминает быбранное действие
         * @private
         */
        _onSubmit: function() {
            this._action = this._getSelect().val();
            BEM.blocks['b-metrika2'].params({
                params: {
                    showCamp: {
                        'mass-action': this._action
                    }
                }
            });
        }

    }, {
        live: true
    });

})();
