/**
 * @fires b-mass-video-extension-confirm#confirm событие нажатия на кнопку OK
 */
BEM.DOM.decl({ block: 'b-mass-video-extension-confirm', implements: 'i-modal-popup-inner-block-interface' }, {
    onSetMod: {
        js: function() {
            this._saveBtn = this.findBlockOn('save', 'button');
            this._autoVideoFlag = this.findBlockOn('auto-video-flag', 'checkbox');
            this._autoVideoFlagInitialValue = this._autoVideoFlag.isChecked();

            this._saveBtn.on('click', function() {
                this.trigger('confirm');
            }, this);
        }
    },

    /**
     * Определяет включен ли флаг 'Автоматически добавлять видеодополнение к новым текстовым объявлениям'
     * @returns {Boolean}
     */
    isAutoVideoFlagOn: function() {
        return this._autoVideoFlag.isChecked();
    },

    /**
     * Были ли изменения
     * @returns {$.Deferred<Boolean>}
     */
    isChanged: function() {
        return $.Deferred().resolve(this._autoVideoFlagInitialValue === this.isAutoVideoFlagOn());
    },

    /**
     * Удаляет блок и его подписки
     * @override
     */
    destruct: function() {
        this._saveBtn.un('click');

        this.__base.apply(this, arguments);
    }
});
