block('b-metrics-goal-selector').elem('list').content()(
    function() {
        var GOALS_MIN_NUMBER_FOR_SEARCH_AVAILIBILITY = 10,
            goals = this.ctx.goals,
            goalsLength = u._.size(goals),
            selectedGoalId = this.ctx.selectedGoalId,
            isSearchEnabled = goalsLength > GOALS_MIN_NUMBER_FOR_SEARCH_AVAILIBILITY,
            disabledGoalsIds = this.ctx.disabledGoalsIds || [],
            goalsItemsJson = u._.reduce(goals, function(acc, goal) {
                var isSelectedGoal = goal.id === selectedGoalId,
                    goalName = u.goals.getGoalName(goal);

                if (goal.status !== u.goals.GOAL_STATUS.deleted) {
                    acc.push({
                        block: 'b-chooser',
                        elem: 'item',
                        elemMods: {
                            disabled: disabledGoalsIds.indexOf(goal.id) !== -1 ? 'yes' : '',
                            selected: isSelectedGoal ? 'yes' : '',
                            hovered: isSelectedGoal ? 'yes' : ''
                        },
                        mix: {
                            block: 'b-metrics-goal-selector',
                            elem: 'item'
                        },
                        js: {
                            text: goalName
                        },
                        name: goal.id,
                        content: {
                            elem: 'name',
                            content: goalName
                        },
                        attrs: {
                            title: goalName
                        }
                    });
                }

                return acc;
            }, []);

        return {
            block: 'b-chooser',
            mods: {
                search: isSearchEnabled ? 'yes' : '',
                'auto-position': 'yes'
            },
            mix: {
                block: 'b-metrics-goal-selector',
                elem: 'chooser'
            },
            content: [
                isSearchEnabled && {
                    block: 'b-metrics-goal-selector',
                    elem: 'search',
                    content: {
                        block: 'b-chooser',
                        elem: 'search',
                        hint: iget2('b-metrics-goal-selector', 'find-goal', 'Найти цель')
                    }
                },
                {
                    elem: 'wrap',
                    mix: {
                        block: 'b-metrics-goal-selector',
                        elem: 'items'
                    },
                    content: goalsItemsJson.length === 0 ?
                        {
                            block: 'b-metrics-goal-selector',
                            elem: 'no-goals-message',
                            content: iget2('b-metrics-goal-selector', 'no-goals-message', 'нет доступных целей')
                        } :
                        goalsItemsJson
                },
                isSearchEnabled && {
                    elem: 'not-found',
                    mix: {
                        block: 'b-metrics-goal-selector',
                        elem: 'no-results'
                    },
                    content: iget2('b-metrics-goal-selector', 'no-results', 'ничего не найдено')
                },
                {
                    block: 'b-metrics-goal-selector',
                    elem: 'footer',
                    content: [
                        {
                            block: 'link',
                            mods: {
                                theme: 'black-without-hover',
                                inner: 'yes'
                            },
                            mix: {
                                block: 'b-metrics-goal-selector',
                                elem: 'metrics-link'
                            },
                            url: u.metrika.getMetrikaUrl('list'),
                            target: 'blank',
                            content: [
                                {
                                    block: 'icon',
                                    mods: { 'size-16': 'metrica' },
                                    mix: { block: 'link', elem: 'icon' }
                                },
                                {
                                    elem: 'inner',
                                    content: iget2('b-metrics-goal-selector', 'set-metrica-goals', 'Настроить цели в Метрике')
                                }
                            ]
                        },
                        {
                            block: 'link',
                            mods: {
                                theme: 'black-without-hover',
                                inner: 'yes'
                            },
                            mix: {
                                block: 'b-metrics-goal-selector',
                                elem: 'metrics-link'
                            },
                            url: u.getUrl('requestAccessToMetrikaCounters', { ulogin: u.consts('ulogin') }),
                            target: 'blank',
                            content: [
                                {
                                    block: 'icon',
                                    mods: { 'size-16': 'metrica' },
                                    mix: { block: 'link', elem: 'icon' }
                                },
                                {
                                    elem: 'inner',
                                    content: iget2('b-metrics-goal-selector', 'get-counter-access', 'Запросить доступ к чужому счетчику')
                                }
                            ]
                        }
                    ]
                }
            ]
        };
    });
