/**
 * @param {Object.<Goal>} goals
 * @param {String} selectedGoalId
 * @param {Array<String>} disabledGoalsIds
 **/
block('b-metrics-goal-selector')(

    replace()(function() {
        var goals = this.ctx.goals,
            selectedGoal,
            selectedGoalName;

        if (this.ctx.selectedGoalId) {
            selectedGoal = goals[this.ctx.selectedGoalId];
            selectedGoalName = u.goals.getGoalName(selectedGoal);
        }

        return {
            block: 'dropdown2',
            mods: { switcher: 'button', theme: 'normal', size: 's', 'has-tick': 'yes' },
            mix: [{
                block: 'b-metrics-goal-selector',
                mods: this.ctx.mods || {},
                js: true
            }].concat(this.ctx.mix || []),
            switcher: {
                block: 'button',
                mods: {
                    theme: 'normal',
                    size: 's',
                    'has-tick': 'yes'
                },
                mix: {
                    block: 'b-metrics-goal-selector',
                    elem: 'opener',
                    elemMods: {
                        selected: selectedGoal ? 'yes' : 'no'
                    }
                },
                attrs: {
                    title: selectedGoalName
                },
                content: selectedGoal ?
                    selectedGoalName :
                    iget2('b-metrics-goal-selector', 'choose-goal', 'выберите цель')
            },
            popup: {
                block: 'popup2',
                zIndexGroupLevel: 7,
                mods: { theme: 'normal', autoclosable: 'yes' },
                content: {
                    block: 'b-metrics-goal-selector',
                    elem: 'list',
                    goals: goals,
                    selectedGoalId: this.ctx.selectedGoalId,
                    disabledGoalsIds: this.ctx.disabledGoalsIds
                }
            }
        }
    })
);
