/**
 * @event b-metrics-goal-selector#change
 * @type {Object}
 * @property {String} goalId id выбранной цели
 *
 * @fires b-metrics-goal-selector#change событие изменения выбора цели
 */
BEM.DOM.decl({ block: 'b-metrics-goal-selector' }, {
    onSetMod: {

        js: function() {
            this._subscriptionManager = BEM.create('i-subscription-manager');

            this._chooser = this.findBlockOn('chooser', 'b-chooser');
            this._dropdown = this.findBlockOn('dropdown2');

            this._subscriptionManager.on(this._chooser, 'select-item', function(event, itemData) {
                this._updateOpener(itemData.text);
                this._closeListPopup();

                this.trigger('change', {
                    value: itemData.name
                });
            }, this);

            // перед открытием попапа проскралливаем к выбранной цели и устанавливаем на ней подсветку
            this._subscriptionManager.on(this._dropdown, 'beforeOpen', function() {
                this._chooser.onControlShowed();
            }, this);

            // клик по ссылке метрики должен закрывать попап
            this.bindTo('metrics-link', 'click', this._closeListPopup, this);
        }
    },

    /**
    * Возвращает текущее значение селектора
    * @returns {String}
    */
    getValue: function() {
        return this._chooser.val();
    },

    /**
    * Удаляет блок и подписки на события
    */
    destruct: function() {
        this._subscriptionManager.dispose();
        this._subscriptionManager.destruct();
        this.unbindFrom('metrics-link', 'click');

        return this.__base.apply(this, arguments);
    },

    /**
    * Обновляет доступность выбора целей
    * @param {Array[String]} disabledGoalsIds массив идентификаторов недоступных целей
    */
    updateGoalsAvailability: function(disabledGoalsIds) {
        var chooser = this._chooser;

        chooser.getAll().forEach(function(chooserItem) {
            if (disabledGoalsIds.indexOf(chooserItem.name) === -1) {
                chooserItem.disabled && chooser.enable(chooserItem.name);
            } else {
                !chooserItem.disabled && chooser.disable(chooserItem.name);
            }
        });
    },

    /**
    * Обновляет текст и внешний вид кнопки после выбора цели
    * @param {String} text текст кнопки
    */
    _updateOpener: function(text) {
        this.setMod(this.elem('opener'), 'selected', 'yes');
        this._dropdown.getSwitcher().setText(u.htmlDecode(text));
    },

    /**
    * Закрывает попап выбора целей
    */
    _closeListPopup: function() {
        this._dropdown.getPopup().hide();
    }
});
