/**
 * @typedef {Object} Goal
 * @property {String} id
 * @property {String} name
 * @property {'Active' | 'Deleted'} status
 * @property {String} domain
 */

/**
 * @param {Array<{goalId: String, price: Number}>} value информация о выбранных целях
 * @param {Object.<Goal>} goals список всех целей
 * @param {String} currency
 **/
block('b-metrics-key-goals-popup')(

    js()(function() {
        return {
            value: this.ctx.value,
            defaultGoalId: this.ctx.defaultGoalId
        }
    }),

    content()(function() {

        return [
            {
                block: 'b-modal-popup-decorator',
                elem: 'header',
                content: [
                    {
                        block: 'b-modal-popup-decorator',
                        elem: 'title',
                        content: [
                            iget2('b-metrics-key-goals-popup', 'title', 'Ключевые цели рекламной кампании'),
                            this.ctx.isBeta && {
                                block: 'b-beta',
                                mods: {
                                    type: 'symbol'
                                }
                            },
                            {
                                block: 'b-help-link',
                                mods: { type: 'modal' },
                                mix: {
                                    block: 'b-metrics-key-goals-popup',
                                    elem: 'help-link'
                                },
                                stretched: true,
                                url: u.getHelpUrl('meaningful-goals')
                            }
                        ]
                    },
                    {
                        block: 'b-modal-popup-decorator',
                        elem: 'header-note',
                        content: iget2(
                            'b-metrics-key-goals-popup',
                            'title-hint',
                            'Алгоритмы оптимизации ставок будут ориентироваться на прогноз конверсий по выбранным целям'
                        )
                    }
                ]
            },
            {
                elem: 'body',
                content: {
                    block: 'b-edit-metrics-key-goals',
                    mix: {
                        block: 'b-metrics-key-goals-popup',
                        elem: 'edit-metrics-key-goals'
                    },
                    goals: this.ctx.goals,
                    value: this.ctx.value,
                    currency: this.ctx.currency
                }
            },
            {
                block: 'b-modal-popup-decorator',
                elem: 'footer',
                content: [
                    {
                        block: 'button',
                        mods: { theme: 'action', size: 's', disabled: 'yes' },
                        mix: [
                            { block: 'b-modal-popup-decorator', elem: 'footer-button' },
                            { block: 'b-metrics-key-goals-popup', elem: 'save' }
                        ],
                        content: iget2('b-metrics-key-goals-popup', 'save', 'Сохранить')
                    },
                    {
                        block: 'button',
                        mods: { size: 's' },
                        mix: [
                            { block: 'b-modal-popup-decorator', elem: 'footer-button' },
                            { block: 'b-metrics-key-goals-popup', elem: 'cancel' }
                        ],
                        content: iget2('b-metrics-key-goals-popup', 'cancel', 'Отмена')
                    }
                ]
            }
        ];
    })
);
