/**
 * @event b-metrics-key-goals-popup#save
 * @type {Object}
 * @property {String} geo id выбранных регионов, разделенных запятой
 *
 * @fires b-metrics-key-goals-popup#save событие сохранения выбора списка регионов показа и их ставок
 * @fires b-metrics-key-goals-popup#cancel событие нажатия на кнопку отмены
 */
BEM.DOM.decl({ block: 'b-metrics-key-goals-popup', implements: 'i-modal-popup-inner-block-interface' }, {
    onSetMod: {
        js: function() {
            BEM.blocks['i-utils'].graspSelf.call(this, {
                _saveBtn: 'button on save',
                _cancelBtn: 'button on cancel',
                _editMetricsKeyGoalsControl: 'b-edit-metrics-key-goals on edit-metrics-key-goals'
            });

            this._subscribe = BEM.create('i-subscription-manager');

            this._subscribe.on(this._saveBtn, 'click', this._onSaveBtnClick, this);
            this._subscribe.on(this._cancelBtn, 'click', this._onCancelBtnClick, this);
            this._subscribe.on(this._editMetricsKeyGoalsControl, 'enableSave', function(event, doEnable) {
                this._updateSaveButtonAvailability(doEnable);
            }, this);
            this._subscribe.on(this._editMetricsKeyGoalsControl, 'change', function() {
                this._isChanged = true;
            }, this);
        }
    },

    /**
     * Были ли изменения
     * @returns {$.Deferred<Boolean>}
     */
    isChanged: function() {
        var deferred = $.Deferred();

        deferred.resolve(this._isChanged === true);

        return deferred;
    },

    /**
     * Удаляет блок и подписки на события
     */
    destruct: function() {
        this._subscribe.dispose();

        return this.__base.apply(this, arguments);
    },

    /**
     * Обработчик события нажатия на кнопку Сохранения
     */
    _onSaveBtnClick: function() {
        if (this._editMetricsKeyGoalsControl.validate()) {
            this._editMetricsKeyGoalsControl.unsubscribe();
            this.trigger('save', { value: this._editMetricsKeyGoalsControl.getValue() });
        }
    },

    /**
     * Обработчик события нажатия на кнопку Отмены
     */
    _onCancelBtnClick: function() {
        this._editMetricsKeyGoalsControl.unsubscribe();
        this.trigger('cancel');
    },

    /**
    * Регулирует доступность кнопоки сохранения
    */
    _updateSaveButtonAvailability: function(doEnable) {
        this._saveBtn.setMod('disabled', doEnable ? '' : 'yes');
    }
});
