block('b-metrics-key-goals')(
    elem('values')(
        content()(function() {
            var currency = this.ctx.currency,
                goals = this.ctx.goals,
                value = this.ctx.value;

            return value.length ?
                value.map(function(item) {
                    return {
                        elem: 'values-item',
                        item: item,
                        goals: goals,
                        currency: currency
                    };
                }) :
                iget2('b-metrics-key-goals', 'no-value-text', 'Не заданы')
        })
    ),

    elem('values-item')(
        def()(function() {
            var deletedGoal = {
                    status: u.goals.GOAL_STATUS.deleted,
                },
                item = this.ctx.item,
                goal = this.ctx.goals[item.goalId] || deletedGoal;

            return applyNext({
                elem: 'values-item',
                elemMods: {
                    deleted: goal.status === u.goals.GOAL_STATUS.deleted ? 'yes' : ''
                },
                goal: goal
            });
        }),

        content()(function() {
            var currency = this.ctx.currency,
                item = this.ctx.item,
                goal = this.goal;

            if (goal.name) {
                return [
                    {
                        elem: 'values-item-goal',
                        content: u.goals.getGoalNameWithDomain(goal)
                    },
                    '&nbsp—&nbsp',
                    {
                        elem: 'values-item-price',
                        content: item.price !== undefined ?
                            item.price + '&nbsp' + u.currencies.get(currency).currency_sign :
                            iget2('b-metrics-key-goals', 'cena_ne_naznachena', 'ценность не назначена'),
                        elemMods: {
                            'price-undefined': item.price === undefined ? 'yes' : ''
                        }
                    }
                ];
            }

            if (u.consts('failedToFetchMetrika')) {
                return iget2('b-metrics-key-goals', 'goal-unavailable', 'Цель временно недоступна');
            }

            return [
                iget2('b-metrics-key-goals', 'no-name-goal-text', 'Цель не найдена'),
                {
                    block: 'icon',
                    mods: { 'size-13': 'alert' },
                    mix: [
                        {
                            block: 'b-metrics-key-goals',
                            elem: 'values-item-icon'
                        },
                        {
                            block: 'b-hintable',
                            js: {
                                hint: iget2(
                                    'b-metrics-key-goals',
                                    'no-name-goal-hint',
                                    'Цели были удалены или стали недоступны по другой причине'
                                )
                            }
                        }
                    ]
                }
            ];
        })
    ),

    elem('values-item-goal')(
        tag()('span')
    ),

    elem('values-item-price')(
        tag()('span')
    )
);
