/**
 * @param {Array<{goalId: String, price: Number}>} value информация о выбранных целях
 * @param {Object.<Goal>} goals
 * @param {String} currency
 * @param {String} [hiddenControlName]
 **/
block('b-metrics-key-goals')(
    def()(function() {
        var ctx = this.ctx,
            value = ctx.value,
            defaultGoal = u._.find(ctx.goals, { isDefault: true }),
            displayedValue;

        if (value && value.length) {
            displayedValue = value;
        } else {
            displayedValue = defaultGoal ? [{ goalId: defaultGoal.id }] : [];
        }

        // cyn@DIRECT-78693: Если выбранных целей нет - то отображаем, в качестве выбранной, дефолтную цель
        // из списка доступных, при этом на сервер её отправляем (__hidden-input) только при редактировании
        // цены конверсии или других целей, чтобы можно было отличить явный выбор пользователя от наших подстановок
        return applyNext({ 'ctx.displayedValue': displayedValue, 'ctx.defaultGoalId': (defaultGoal || {}).id });
    }),

    js()(function() {
        return u._.pick(this.ctx, ['goals', 'displayedValue', 'currency', 'isBeta', 'modelParams', 'defaultGoalId']);
    }),

    content()(function() {
        var ctx = this.ctx,
            currency = ctx.currency,
            goals = ctx.goals,
            value = ctx.value,
            displayedValue = ctx.displayedValue,
            strategyData = ctx.strategyData,
            goalsLength = u._.size(goals),
            defaultGoal = u._.find(ctx.goals, { isDefault: true }),
            warningJsonHidden = 'yes',
            hiddenInputJson,
            warningJson;

        if (this.ctx.hiddenControlName) {
            hiddenInputJson = {
                block: 'b-metrics-key-goals',
                elem: 'hidden-input',
                hiddenControlName: this.ctx.hiddenControlName,
                value: value
            };
        }

        displayedValue.forEach(function(el) {
            goals[el.goalId] = goals[el.goalId] || u._.extend({
                id: el.goalId,
                status: u.goals.GOAL_STATUS.deleted
            }, el);
        });

        var isAvailableStrategyForAllKeyGoals = strategyData.name === u.strategy.AUTOBUDGET_ROI ||
            strategyData.name === u.strategy.AUTOBUDGET;

        if (isAvailableStrategyForAllKeyGoals &&
            strategyData.options.goal_id === u.consts('allKeyGoals') &&
            !displayedValue.some(function(goal) {
                return goal.goalId != defaultGoal.id;
            })
        ) {
            warningJsonHidden = 'no';
        }

        warningJson = {
            block: 'b-warning-message',
            mix: {
                block: 'b-metrics-key-goals',
                elem: 'warning-message',
                elemMods: {
                    hidden: warningJsonHidden
                }
            },
            mods: {
                theme: 'yellow'
            },
            icon: {
                block: 'icon',
                mods: { 'size-12': 'info' }
            },
            content: iget2('b-metrics-key-goals', 'optimization-settings-warning', 'Оптимизация по всем ключевым целям недоступна. Не заданы ключевые цели или заданы только вовлеченные сессии.')
        };

        return goalsLength || displayedValue.length ?
            [
                hiddenInputJson,
                warningJson,
                {
                    elem: 'values',
                    elemMods: { hidden: displayedValue.length ? '' : 'yes' },
                    currency: currency,
                    value: displayedValue,
                    goals: goals
                },
                {
                    block: 'button',
                    mods: {
                        theme: 'normal',
                        size: 's',
                        disabled: u.consts('failedToFetchMetrika') ? 'yes' : ''
                    },
                    mix: {
                        block: 'b-metrics-key-goals',
                        elem: 'opener'
                    },
                    content: displayedValue.length ?
                        iget2('b-metrics-key-goals', 'change-btn', 'Изменить') :
                        iget2('b-metrics-key-goals', 'choose-btn', 'Выбрать')
                }
            ] :
            [
                hiddenInputJson,
                warningJson,
                {
                    block: 'dropdown2',
                    mods: { switcher: 'button', theme: 'normal', size: 's', 'has-tick': 'yes' },
                    switcher: iget2('b-metrics-key-goals', 'set-metrics-goals', 'Настройте цели в Метрике'),
                    popup: {
                        block: 'menu',
                        mods: { type: 'navigation', theme: 'normal', size: 's' },
                        items: [
                            {
                                text: iget2('b-metrics-key-goals', 'set-goals', 'Настроить цели'),
                                url: u.metrika.getMetrikaUrl('list'),
                                target: '_blank'
                            },
                            {
                                text: iget2('b-metrics-key-goals', 'get-counter-access', 'Запросить доступ к чужому счетчику'),
                                url: u.getUrl('requestAccessToMetrikaCounters', {
                                    ulogin: u.consts('ulogin')
                                }),
                                target: '_blank'
                            }
                        ]
                    }
                }
            ]
    })
);
