BEM.DOM.decl({ block: 'b-metrics-key-goals' }, {
    onSetMod: {
        js: function() {
            this._subscriptionManager = BEM.create('i-subscription-manager');

            this._opener = this.findBlockOn('opener', 'button');

            this._campModel = BEM.MODEL.getOne(this.params.modelParams);
            this._strategyModel = this._campModel.get('strategy2');

            if (this._opener) {
                this._subscriptionManager.on(this._opener, 'click', function() {
                    this._openEditPopup();
                }, this);
            }

            this._subscriptionManager.on(this._strategyModel, 'change', function() {
                var isAvailableStrategyForAllKeyGoals = this._checkAvailableStrategyForAllKeyGoals();

                if (
                    !isAvailableStrategyForAllKeyGoals ||
                    this._strategyModel.get('options').goal_id !== u.consts('allKeyGoals')
                ) {
                    this.setMod(this.elem('warning-message'), 'hidden', 'yes');
                }
            }, this);

            this._displayedValue = this.params.displayedValue;
        }
    },

    /**
     * Проверяет, подходит ли стратегия для ключевых целей
     */
    _checkAvailableStrategyForAllKeyGoals: function() {
        return this._strategyModel.get('name') === u.strategy.AUTOBUDGET_ROI || u.strategy.AUTOBUDGET
    },

    /**
    * Удаляет блок и подписки на события
    */
    destruct: function() {
        this._subscriptionManager.dispose();
        this._subscriptionManager.destruct();

        return this.__base.apply(this, arguments);
    },

    /**
    * Открывает попап задания ключевых целей и инициализирует подписки на его события
    */
    _openEditPopup: function() {
        var modalPopupDecorator = BEM.DOM.blocks['b-modal-popup-decorator'].create2(null, { bodyScroll: false }, $),
            popup = modalPopupDecorator.getPopup(),
            instance,
            params = this.params;

        instance = modalPopupDecorator
            .on('close-blocked', function() {
                BEM.blocks['b-user-dialog'].confirm({
                    message: iget2('b-metrics-key-goals', 'changes-will-not-save', 'Изменения не будут сохранены. Продолжить?'),
                    onConfirm: function() {
                        modalPopupDecorator.hide({ force: true });
                    }
                });
            }, this)
            .setPopupContent({
                block: 'b-metrics-key-goals-popup',
                goals: params.goals,
                value: this._displayedValue,
                currency: params.currency,
                defaultGoalId: params.defaultGoalId,
                isBeta: params.isBeta
            })
            .on('save', function(event, data) {
                var isAvailableStrategyForAllKeyGoals = this._checkAvailableStrategyForAllKeyGoals();

                this._displayedValue = data.value;

                BEM.DOM.replace(
                    this.findElem('values'),
                    BEMHTML.apply({
                        block: 'b-metrics-key-goals',
                        elem: 'values',
                        currency: this.params.currency,
                        goals: this.params.goals,
                        value: this._displayedValue
                    })
                );

                this.setMod(this.elem('values'), 'hidden', data.value.length ? '' : 'yes');

                if (this.elem('hidden-input').length) {
                    this.elem('hidden-input')
                        .val(JSON.stringify(u.goals.transformValueToServerFormat(data.value)));
                }

                this._opener.elem('text').text(data.value.length ?
                    iget2('b-metrics-key-goals', 'change-btn', 'Изменить') :
                    iget2('b-metrics-key-goals', 'choose-btn', 'Выбрать')
                );

                this._campModel.set('meaningful_goals', u.goals.transformValueToServerFormat(data.value));

                if (
                    (isAvailableStrategyForAllKeyGoals) &&
                    this._strategyModel.get('options').goal_id === u.consts('allKeyGoals') &&
                    !data.value.some(function(goal) {
                        return goal.goalId != this.params.defaultGoalId;
                    }.bind(this))
                ) {
                    this.setMod(this.elem('warning-message'), 'hidden', 'no');
                } else {
                    this.setMod(this.elem('warning-message'), 'hidden', 'yes');
                }

                modalPopupDecorator.hide({ force: true });
            }, this)
            .on('cancel', function() {
                modalPopupDecorator.hide({ force: true });
            });

        popup.on('hide', function() {
            modalPopupDecorator.destruct();
        });

        instance._popup = modalPopupDecorator;
        modalPopupDecorator.show();

        return instance;
    }
});
