block('b-metrika-counters-popup-adapter')(

    /**
     *
     * @param {String} ctx.metrikaCounters счётчики метрики
     * @param {Object} ctx.dataModel параметры модели
     * @param {Boolean} ctx.isPerformance флаг кампании смарт
     * @param {BEMJSON} ctx.mixHintElem хинт, который нужно примиксовать к строке
     * @param {Boolean} ctx.isViewOnly режим просмотра или редактирования
     * @param {String} ctx.OrderID
     */
    js()(function() {
        return {
            dataModel: this.ctx.dataModel,
            isPerformance: this.ctx.isPerformance,
            OrderID: this.ctx.OrderID,
            isExperimentsOn: this.ctx.isExperimentsOn
        };
    }),

    content()(function() {
        var metrikaCounters = this.ctx.metrikaCounters,
            OrderID = this.ctx.OrderID,
            mixedHint = this.ctx.mixHintElem,
            isViewOnly = this.ctx.isViewOnly,
            buttonSize = this.ctx.buttonSize;

        if (['s', 'm'].indexOf(buttonSize) === -1) {
            buttonSize = 's';
        }

        return [
            {
                elem: 'metrika-counters-wrap',
                mix: mixedHint,
                content: {
                    elem: 'metrika-counters-string',
                    elemMods: { visible: metrikaCounters.length > 0 ? 'yes' : '' },
                    counters: metrikaCounters || '',
                    OrderID: OrderID,
                    isEditable: isViewOnly
                }
            },
            !isViewOnly && {
                block: 'button',
                mods: { theme: 'normal', size: buttonSize },
                mix: {
                    block: 'b-metrika-counters-popup-adapter',
                    elem: 'opener'
                },
                content: metrikaCounters ? iget2('b-metrika-counters-popup-adapter', 'izmenit', 'Изменить') : iget2('b-metrika-counters-popup-adapter', 'dobavit', 'Добавить')
            },
            {
                block: 'b-hidden',
                mix: { block: 'b-metrika-counters-popup-adapter', elem: 'hidden-value' },
                attrs: {
                    name: 'metrika_counters',
                    value: metrikaCounters
                }
            }
        ];
    }),

    elem('metrika-counters-string')(
        content()(function() {
            return u['b-metrika-counters-popup-adapter']
                .formatMetrikaCounters(this.ctx.counters, this.ctx.OrderID, this.ctx.isViewOnly);
        })
    )
);
