BEM.DOM.decl({ block: 'b-metrika-counters-popup-adapter' }, {
    onSetMod: {
        js: function() {
            this._subMan = BEM.create('i-subscription-manager');
            this._initPopup();
            this._initEvents();
        }
    },

    /**
     * Деструктор
     */
    destruct: function() {
        this._subMan.dispose();
        this._subMan.destruct();

        this.__base.apply(this);
    },

    _showPopup: function() {
        this._notificationBlock.prepareData();
        this._popupDecorator.show();
    },

    /**
     * Инициализирует попап
     * @private
     */
    _initPopup: function() {
        var _this = this;
        if (!this._popupDecorator) {
            this._popupDecorator = BEM.DOM.blocks['b-modal-popup-decorator'].create2(undefined, { bodyScroll: false }, $);
            this._notificationBlock = this._popupDecorator.setPopupContent({
                block: 'b-metrika-counters-popup',
                dataModel: _this.params.dataModel,
                isPerformance: _this.params.isPerformance,
                needCheckCountersOwner: _this.params.needCheckCountersOwner,
                isExperimentsOn: _this.params.isExperimentsOn
            });
        }
    },

    /**
     * Инициализирует события на блоке
     * @private
     */
    _initEvents: function() {
        var popup = this._popupDecorator;

        this._subMan
            .on(this._notificationBlock, 'save', function(e, data) {
                this._updateHint(data);
                this._updateHidden(data);
                this._updateButtonText(!!data);

                this._notificationBlock.update();
                this._popupDecorator.hide({ force: true });
            }, this)
            .on(this._notificationBlock, 'cancel', function() {
                this._popupDecorator.hide({ force: true });
            }, this);

        this._subMan.wrap(popup)
            .on('close-blocked', function() {
                BEM.blocks['b-user-dialog']
                    .confirm({
                        message: iget2('b-metrika-counters-popup-adapter', 'u-vas-est-nesohranennye', 'У вас есть несохраненные изменения. Продолжить?'),
                        confrimButtonText: iget2('b-metrika-counters-popup-adapter', 'da-121', 'Да'),
                        cancelButtonText: iget2('b-metrika-counters-popup-adapter', 'net-122', 'Нет'),
                        parentPopup: popup.getPopup(),
                        onConfirm: function() {
                            popup.hide({ force: true });
                        },
                        callbackCtx: this
                    });
            }, this);
    },

    /**
     * Обновляет хинт со счетчиками метрики
     * @param {String} countersStr
     * @private
     */
    _updateHint: function(countersStr) {
        var _this = this;

        BEM.DOM.update(
            this.elem('metrika-counters-wrap'),
            BEMHTML.apply({
                block: 'b-metrika-counters-popup-adapter',
                elem: 'metrika-counters-string',
                elemMods: { visible: countersStr.length > 0 ? 'yes' : '' },
                counters: countersStr,
                OrderID: _this.params.OrderID
            })
        );
    },

    /**
     * Обновляет value у скрытого инпута metrika_counters
     * @param {String} countersStr
     * @private
     */
    _updateHidden: function(countersStr) {
        this.elem('hidden-value').val(countersStr);
    },

    /**
     * Обновляем текст на кнопке
     * @param {Boolean} hasCounters флаг, сигнализирующий о наличии счетчиков
     * @private
     */
    _updateButtonText: function(hasCounters) {
        this._getBtn().setText(hasCounters ? iget2('b-metrika-counters-popup-adapter', 'izmenit', 'Изменить') : iget2('b-metrika-counters-popup-adapter', 'dobavit', 'Добавить'));
    },

    /**
     * кешируем кнопку
     * @returns {*|BEM}
     * @private
     */
    _getBtn: function() {
        return this._btn || (this._btn = this.findBlockOn('opener', 'button'));
    }

}, {
    live: function() {
        this.liveInitOnBlockInsideEvent('click', 'button', function() {
            this._showPopup();
        });
    }
});
