u.register({
    'b-metrika-counters-popup-adapter': {
        /**
         * Функция обработки счетчиков метрики
         * @param {String} counters строка со счетчиками
         * @param {String} OrderID
         * @param {Boolean} isViewOnly флаг, от которого завист будут счетчики ссылками или текстом
         * @returns {Array} возвращает массив строк или массив объектов BEMJSON
         */
        formatMetrikaCounters: function(counters, OrderID, isViewOnly) {
            return counters.split(/[,\s]+/g).map(function(counter, i) {
                return !!counter &&
                    [
                        (i ? ', ' : ''),
                        isViewOnly ?
                            counter :
                            {
                                block: 'link',
                                content: counter,
                                url: u.getMetrikaUrl(u.formatUrl({
                                    path: 'stat/direct_summary',
                                    query: {
                                        id: counter,
                                        // нестандартная кодировка, описана тут
                                        // https://st.yandex-team.ru/METR-21342#1463559252000
                                        filter: +OrderID ?
                                            encodeURIComponent(
                                                '(ym:s:lastDirectClickOrder==\'' +
                                                OrderID +
                                                '\')'.replace(/'/g, '%27')
                                            ) :
                                            undefined,
                                        attribution: 'Last'
                                    }
                                })),
                                target: '_blank'
                            },
                    ]
            }, this);
        }
    }
});
