BEM.DOM.decl({
    block: 'b-metrika-counters-popup',
    modName: 'type',
    modVal: 'mass-actions',
    implements: 'i-modal-popup-inner-block-interface'
}, {
    _ACTIONS: {
        deleteAll: 'deleteAll',
        add: 'add',
        replace: 'replace',
        none: 'none'
    },

    onSetMod: {
        js: function() {
            u.graspSelf.call(this, {
                _add: '? button on add-button',
                _replace: 'button on replace-button',
                _deleteAll: '? button on delete-button'
            });
            this._currentAction = this._ACTIONS.none;

            this.__base.apply(this, arguments);
        },

        // установку модификаторов на _save необходимо отменить
        'check-request': function() {
            return false;
        },

        processing: function(modName, modVal) {
            if (modVal) {
                switch (this._currentAction) {
                    case this._ACTIONS.add:
                        this._text = this._add.getText();
                        this._add.setText(iget2('b-metrika-counters-popup', 'dobavlyaetsya', 'Добавляется') + '...');
                        break;
                    case this._ACTIONS.replace:
                        this._text = this._replace.getText();
                        this._replace.setText(iget2('b-metrika-counters-popup', 'izmenyaetsya', 'Изменяется') + '...');
                        break;
                    case this._ACTIONS.deleteAll:
                        this._text = this._deleteAll.getText();
                        this._deleteAll.setText(iget2('b-metrika-counters-popup', 'udalyaetsya', 'Удаляется') + '...');
                        break;
                }
            } else {
                this['_' + this._currentAction].setText(this._text);
                this._currentAction = this._ACTIONS.none;
            }
            this._toggleButtonsState(true, modVal == 'yes');
            // событие, чтобы изменить состояние крестика на попапе
            this.trigger('buttons-disabled', { disabled: modVal == 'yes' });
        }
    },

    /**
     * Обработка окончания внешнего сохранения
     * @override
     */
    onCountersSaveFinished: function() {
        this.delMod('processing');
    },

    /**
     * Инициализация событий
     * @override
     * @private
     */
    _initCustomActions: function() {
        this._deleteAll && this._subMan.on(this._deleteAll, 'click', function() {
            this._currentAction = this._ACTIONS.deleteAll;
            this.trigger('deleteAll');
            this.setMod('processing', 'yes');
        }, this);

        this._add && this._subMan.on(this._add, 'click', function() {
            this._currentAction = this._ACTIONS.add;
            this._validateCounters();
        }, this);

        this._subMan
            .on(this._replace, 'click', function() {
                this._currentAction = this._ACTIONS.replace;
                // Если решат отключить валидацию, то в i-mass-action-metrika-counters
                // надо добавить обработку ошибки невалидного счетчика:
                // "errors":[{"path":"metrika_counters[0]","code":"DefectIds.MUST_BE_VALID_ID" для {"cids":[123],"metrika_counters":[0]}
                this._validateCounters();
            }, this)
            .on(this._metrikaCounters, 'state', function(e, data) {
                data || (data = {});
                this._toggleButtonsState(data.canSave, this.getMod('processing') == 'yes');
            }, this);
    },

    /**
     * Смена состояния кнопок
     * @param {Boolean} state - состояние контрола ввода счетчиков
     * @param {Boolean} isProcessing - флаг, что снаружи происходит сохранение
     * @private
     */
    _toggleButtonsState: function(state, isProcessing) {
        if (!this.params.readonly) {
            this._add && this._add.toggleMod('disabled', '', 'yes', state && !isProcessing);
            this._replace.toggleMod('disabled', '', 'yes', state && !isProcessing);
            this._deleteAll && this._deleteAll.toggleMod('disabled', '', 'yes', !isProcessing);
        }
        this._cancel.toggleMod('disabled', '', 'yes', !isProcessing);
    },

    /**
     * Обработка кнопок
     * @override
     * @private
     */
    _validateCounters: function() {
        this.setMod('processing', 'yes');

        this.__base.apply(this, arguments);
    },

    /**
     * Триггер сообщения
     * @override
     * @private
     */
    _onCountersValidated: function() {
        this.trigger(this._currentAction, this._metrikaCounters.getCounters());
    }
});
