block('b-metrika-counters-popup')(
    js()(function() {
        return {
            isExperimentsOn: this.ctx.isExperimentsOn,
            readonly: this.ctx.readonly
        }
    }),

    content()(function() {
        var ctx = this.ctx,
            isPerformance = ctx.isPerformance,
            needCheck = ctx.needCheckCountersOwner || isPerformance,
            dataModel = ctx.dataModel,
            counters = ctx.counters,
            readonly = ctx.readonly;

        return [
            {
                elem: 'header',
                mix: { block: 'b-modal-popup-decorator', elem: 'header' },
                isPerformance: isPerformance
            },
            {
                elem: 'body',
                mix: { block: 'b-modal-popup-decorator', elem: 'body' },
                isPerformance: isPerformance,
                dataModel: dataModel,
                needCheck: needCheck,
                counters: counters
            },
            {
                elem: 'footer',
                mix: { block: 'b-modal-popup-decorator', elem: 'footer' },
                isPerformance: isPerformance,
                readonly: readonly
            }
        ];
    }),

    elem('header').content()(function() {
        var isPerformance = this.ctx.isPerformance;

        return [
            {
                elem: 'header-text',
                mix: { block: 'b-modal-popup-decorator', elem: 'header-text' },
                content:
                    isPerformance ?
                        iget2('b-metrika-counters-popup', 'nomer-schyotchika-metriki', 'Номер счётчика Метрики') :
                        iget2('b-metrika-counters-popup', 'schyotchiki-metriki', 'Счётчики Метрики')
            },
            {
                elem: 'metrika-note',
                mix: { block: 'b-modal-popup-decorator', elem: 'header-note' },
                content:
                    isPerformance ?
                        iget2('b-metrika-counters-popup', 'ukazat-mozhno-tolko-odin', 'Указать можно только один дополнительный счётчик.') :
                        iget2(
                            'b-metrika-counters-popup',
                            'nomera-schyotchikov-ukazyvayutsya-cherez',
                            'Номера счётчиков указываются через запятую или пробел.'
                        )
            }
        ];
    }),

    elem('body').content()(function() {
        var isPerformance = this.ctx.isPerformance,
            limitMetrikaCountersOnCampaign = 100;

        return {
            block: 'b-metrika-counters',
            mix: { block: 'b-metrika-counters-popup', elem: 'input' },
            limit: isPerformance ? 1 : limitMetrikaCountersOnCampaign,
            js: {
                dataModel: this.ctx.dataModel,
                needCheck: this.ctx.needCheck,
                counters: this.ctx.counters
            }
        }
    }),

    elem('footer').content()(function() {
        return [
            {
                block: 'button',
                mods: { theme: 'action' },
                mix: [
                    { block: 'b-metrika-counters-popup', elem: 'accept-button' },
                    { block: 'b-modal-popup-decorator', elem: 'footer-button' }
                ],
                content: iget2('b-metrika-counters-popup', 'sohranit', 'Сохранить')
            },
            {
                block: 'button',
                mix: [
                    { block: 'b-metrika-counters-popup', elem: 'decline-button' },
                    { block: 'b-modal-popup-decorator', elem: 'footer-button' }
                ],
                content: iget2('b-metrika-counters-popup', 'otmena', 'Отмена')
            }
        ];
    })
);
