BEM.DOM.decl({ block: 'b-metrika-counters-popup', implements: 'i-modal-popup-inner-block-interface' }, {
    onSetMod: {
        js: function() {
            this._metrikaCounters = this.findBlockInside('b-metrika-counters');
            this._subMan = BEM.create('i-subscription-manager');

            u.graspSelf.call(this, {
                _save: '? button on accept-button',
                _cancel: 'button on decline-button'
            });

            this._initActions();
        },

        'check-request': function(modName, modVal) {
            if (modVal) {
                this._acceptBtnText = this._save.getText();
                this._save.setText(iget2('b-metrika-counters-popup', 'sohranyaetsya', 'Сохраняется') + '...');
            } else {
                this._save.setText(this._acceptBtnText);
            }
        }
    },

    /**
     * Деструктор
     */
    destruct: function() {
        this._subMan.dispose();
        this._subMan.destruct();

        this.__base.apply(this);
    },

    /**
     * Были ли изменения в счетчиках
     * @returns {Promise}
     * @private
     */
    isChanged: function() {
        var deferred = $.Deferred(),
            isChanged = this._counters != this._metrikaCounters.getCounters();

        deferred.resolve(isChanged);

        return deferred;
    },

    /**
     * Дергает метод инициализации счетчиков
     */
    prepareData: function() {
        this._metrikaCounters.prepareToShow();
        this._counters = this._metrikaCounters.getCounters();
    },

    /**
     * Обновление счетчиков по внешним данным
     */
    update: function() {
        this._metrikaCounters.updateModel();
    },

    /**
     * Обработка окончания внешнего сохранения
     * Переопеределено в модификаторе
     */
    onCountersSaveFinished: function() { },

    /**
     * Инициализация общих обработчиков
     * @private
     */
    _initActions: function() {
        this._subMan
            .on(this._cancel, 'click', function() {
                this.trigger('cancel');
            }, this)
            .on(this._metrikaCounters, 'check-request', function(e, modVal) {
                if (modVal) {
                    this.setMod('check-request', 'yes');
                } else {
                    this.delMod('check-request');
                }
            }, this);

        this._initCustomActions();
    },

    /**
     * Инициализация обработчиков
     * @private
     */
    _initCustomActions: function() {
        this._subMan
            .on(this._save, 'click', function() {

                this.params.isExperimentsOn && this._metrikaCounters.isCountersUsed() ?
                    BEM.blocks['b-user-dialog'].confirm({
                        message: iget2(
                            'b-metrika-counters-popup',
                            'counters-used-in-experiments',
                            'Вы убрали счетчик, в котором есть активные эксперименты, вы хотите сохранить изменения?'
                        ),
                        confrimButtonText: iget2('b-metrika-counters', 'da', 'Да'),
                        cancelButtonText: iget2('b-metrika-counters', 'net', 'Нет'),
                        onConfirm: function() {
                            this._validateCounters();
                        }.bind(this)
                    }) :
                    this._validateCounters();
            }, this)
            .on(this._metrikaCounters, 'state', function(e, data) {
                data || (data = {});
                this._save.toggleMod('disabled', '', 'yes', data.canSave);
            }, this);
    },

    /**
     * Обработчик кнопки сохранения
     * @private
     */
    _validateCounters: function(action) {
        var valid = this._metrikaCounters.validate(),
            _this = this;
        if (valid) {
            if (valid.done) {
                valid.done(function(isValid) {
                    if (isValid) {
                        _this._onCountersValidated();
                    } else {
                        _this.onCountersSaveFinished();
                    }
                });
            } else {
                _this._onCountersValidated();
            }
        }
    },

    /**
     * Триггер сообщения
     * @private
     */
    _onCountersValidated: function() {
        this.trigger('save', this._metrikaCounters.getCounters());
    }
});
