/**
 * Блок выбора счётчиков метрики для кампании
 *
 * @param {Number} [limit] лимит доступных для выбора счётчиков
 */
block('b-metrika-counters')(
    def()(function() {
        var limit = +this.ctx.limit,
            single,
            limitMetrikaCountersOnCampaign = 100;

        // по умолчанию задан лимит в limitMetrikaCountersOnCampaign счётчиков
        (isNaN(limit) || limit < 1) && (limit = limitMetrikaCountersOnCampaign);

        single = limit === 1;

        return applyNext({
            // при ограничении в 1 счётчик блок более узкий
            'mods.single': single ? 'yes' : '',
            _single: single,
            'ctx.limit': limit
        });
    }),

    js()(function() {
        return {
            limit: this.ctx.limit
        };
    }),

    mode('input-label')(

        match(function() { return true })(function() {
            return iget2('b-metrika-counters', 'nomera-schyotchikov', 'Номера счётчиков');
        }),

        match(function() { return this._single; })(function() {
            return iget2('b-metrika-counters', 'nomer-schyotchika', 'Номер счётчика');
        })
    ),

    content()(function() {
        return [
            {
                block: 'input',
                placeholder: apply('input-label'),
                content: { elem: 'control' }
            },
            {
                elem: 'errors',
                elemMods: { 'with-error': 'no' }
            }
        ];
    })
);
