block('b-metrika-link')(
    def()(function() {
        var ctx = this.ctx,
            metrikaCounters = ctx.metrikaCounters,
            noMetrikaCounter = (metrikaCounters === undefined || metrikaCounters === null ||
                metrikaCounters.split(',').length !== 1),
            metrikaFilter = ctx.noFilter ?
                undefined :
                {
                    last_significant_click: encodeURIComponent('(ym:s:lastSignDirectClickOrder==\'' + (ctx.orderId) + '\')'.replace(/'/g, '%27')),
                    last_yandex_direct_click: encodeURIComponent('(ym:s:LAST_YANDEX_DIRECT_CLICKDirectClickOrder==\'' + (ctx.orderId) + '\')'.replace(/'/g, '%27')),
                    last_click: encodeURIComponent('(ym:s:lastDirectClickOrder==\'' + (ctx.orderId) + '\')'.replace(/'/g, '%27')),
                    first_click: encodeURIComponent('(EXISTS+ym:u:userID+WITH+(ym:u:firstDirectClickOrder)==\'' + (ctx.orderId) + '\')'.replace(/'/g, '%27'))
                }[ctx.attribution || 'last_click'],
            metrikaPeriod = !ctx.noPeriod && ctx.dateFrom && ctx.dateTo ?
                ctx.dateFrom + '%3A' + ctx.dateTo :
                undefined,
            metrikaGoal = ctx.goalId && !ctx.noGoal ?
                ctx.goalId :
                undefined,
            metrikaGroup = ctx.group && ctx.group !== 'day' && !ctx.noGroup ?
                (ctx.group === 'week' ? 'week' : 'month') :
                undefined,
            metrikaAttribution = {
                last_significant_click: 'LastSign',
                last_click: 'Last',
                first_click: 'First',
                last_yandex_direct_click: 'LAST_YANDEX_DIRECT_CLICK'
            }[ctx.attribution || 'last_click'],
            metrikaUrl = u.getMetrikaUrl(u.formatUrl({
                path: 'stat/direct_summary',
                query: {
                    id: metrikaCounters,
                    filter: metrikaFilter,
                    attribution: metrikaAttribution,
                    period: metrikaPeriod,
                    goal: metrikaGoal,
                    group: metrikaGroup
                }
            }));

        return noMetrikaCounter ?
            '' :
            applyCtx([
                {
                    block: 'link',
                    mods: { inner: 'yes' },
                    mix: (ctx.mix || []).concat([{ block: 'b-metrika-link' }]),
                    target: '_blank',
                    url: metrikaUrl,
                    content: [
                        {
                            block: 'icon',
                            mods: { 'size-12': 'metrika' },
                            mix: { block: 'link', elem: 'icon' }
                        },
                        {
                            elem: 'inner',
                            content: iget2('b-metrika-link', 'pereyti-v-metriku', 'Перейти в Метрику')
                        }
                    ]
                },
                {
                    block: 'b-help-link',
                    mods: { type: 'modal' },
                    mix: { block: 'b-metrika-link', elem: 'help' },
                    url: u.getHelpUrl('statistics-metrika'),
                    stretched: true,
                    icon: 'question'
                }
            ]);
    })
);
