BEM.DOM.decl('b-metrika', {

    onSetMod: {

        js: function() {
            var event = this.params.event || 'mousedown',
                blockName = this.params.blockName;

            this._goals = this.params.goals || (this.params.goal && [{
                name: this.params.goal,
                counter: this.params.counter,
                visitParams: this.params.visitParams
            }]);

            blockName ?
                this.findBlockOn(blockName).on(event, this._onTrigger, this) :
                this.bindTo(event, this._onTrigger);
        }

    },

    _onTrigger: function() {
        if (this._goals) {
            this._goals.forEach(function(goal) {
                BEM.blocks['b-metrika2']
                    .getCounter(goal.counter || 191494)
                    .done(function(counter) {
                        counter.reachGoal(goal.name || goal, goal.visitParams);
                    });
            });

            return;
        }

        if (this.params.visitParams) {
            BEM.blocks['b-metrika2']
                .getCounter(this.params.counter || 191494)
                .done(function(counter) {
                    counter.params(this.params.visitParams);
                }.bind(this));
        }

        return true;
    }
}, {
    reachGoal: function(goal, params) {
        BEM.blocks['b-metrika2']
            .getCounter(191494)
            .done(function(counter) {
                counter.reachGoal(goal, params);
            });
    }
});
