block('b-minus-phrases-manager')(
    elem('header')(

        mode('target-text')(function() {
            return {
                undefined: iget2('b-minus-phrases-manager', 'vybrat', 'Выбрать'),
                campaign: iget2('b-minus-phrases-manager', 'na-kampaniyu', 'на кампанию'),
                group: iget2('b-minus-phrases-manager', 'na-gruppu', 'на группу')
            }[this.ctx.target];
        }),

        mix()(function() {
            return {
                block: 'i-glue',
                js: {
                    modelParams: {
                        name: 'b-minus-phrases-manager',
                        id: this.ctx.itemData.id
                    }
                }
            };
        }),

        content()(function() {
            var itemData = this.ctx.itemData;

            return [
                {
                    elem: 'header-phrase',
                    content: iget2('b-minus-phrases-manager', 'minus-fraza', 'Минус-фраза')
                },
                {
                    block: 'select',
                    mods: { width: 'min-120' },
                    js: { elemPopupMods: { 'hide-first-option': 'yes' } },
                    mix: [
                        { block: 'b-minus-phrases-manager', elem: 'header-target' },
                        {
                            block: 'i-glue',
                            elem: 'model-field',
                            js: { name: 'target', type: 'select' }
                        }
                    ],
                    content: [
                        {
                            block: 'button',
                            content: apply('target-text', { 'ctx.target': itemData.target })
                        },
                        {
                            elem: 'control',
                            content: ['undefined', 'campaign', 'group'].map(function(target) {
                                var targetBemjson = {
                                    elem: 'option',
                                    attrs: { value: target },
                                    content: apply('target-text', { 'ctx.target': target })
                                };

                                if (target === itemData.target) {
                                    targetBemjson.attrs.selected = 'selected';
                                }

                                return targetBemjson;
                            }, this)
                        }
                    ]
                },
                {
                    elem: 'header-target-info-group',
                    content: iget2('b-minus-phrases-manager', 'na-gruppu-125', 'На группу')
                },
                {
                    elem: 'header-target-info-campaign',
                    content: iget2('b-minus-phrases-manager', 'na-kampaniyu-126', 'На кампанию')
                }
            ];
        })
    ),

    mod('stat-type', 'moc').elem('header-target-info-campaign').def()('')
);
