block('b-minus-phrases-manager')(
    elem('phrase-item')(

        mode('target-text')(function() {
            return {
                campaign: iget2('b-minus-phrases-manager', 'na-kampaniyu', 'на кампанию'),
                group: iget2('b-minus-phrases-manager', 'na-gruppu', 'на группу')
            }[this.ctx.target];
        }),

        mix()(function() {
            return [
                {
                    block: 'i-glue',
                    js: {
                        modelParams: {
                            name: 'b-minus-phrases-manager__phrase-item',
                            id: this.ctx.itemData.id
                        }
                    }
                },
                {
                    block: 'i-glue',
                    elem: 'model-field',
                    js: {
                        type: 'mod',
                        name: 'prevPhraseHaveAnotherCid',
                        block: 'b-minus-phrases-manager',
                        elem: 'phrase-item',
                        modName: 'separated'
                    }
                },
                {
                    elemMods: {
                        separated: this.ctx.itemData.prevPhraseHaveAnotherCid ? 'yes' : ''
                    }
                }
            ];
        }),

        content()(function() {
            var itemData = this.ctx.itemData;

            return {
                elem: 'phrase-item-content',
                content: [
                    {
                        block: 'b-minus-phrases-manager',
                        elem: 'error',
                        js: { itemId: this.ctx.itemData.id },
                        mix: {
                            block: 'i-glue',
                            elem: 'model-field',
                            js: {
                                type: 'mod',
                                name: 'haveError',
                                block: 'b-minus-phrases-manager',
                                elem: 'error',
                                modName: 'showed'
                            }
                        },
                        content: [
                            {
                                block: 'input',
                                mods: { clear: 'no' },
                                value: itemData.text,
                                name: 'text',
                                mix: [
                                    {
                                        block: 'b-minus-phrases-manager',
                                        elem: 'phrase-item-text'
                                    },
                                    {
                                        block: 'i-glue',
                                        elem: 'model-field',
                                        js: { name: 'text', type: 'input' }
                                    }
                                ],
                                content: [
                                    { elem: 'control' }
                                ]
                            }
                        ]
                    },
                    {
                        block: 'select',
                        mods: {
                            width: 'min-120',
                            'on-scroll': 'close'
                        },
                        mix: [
                            { block: 'b-minus-phrases-manager', elem: 'phrase-item-target' },
                            {
                                block: 'i-glue',
                                elem: 'model-field',
                                js: { name: 'target', type: 'select' }
                            }
                        ],
                        content: [
                            {
                                block: 'button',
                                content: apply('target-text', { 'ctx.target': itemData.target })
                            },
                            {
                                elem: 'control',
                                content: ['campaign', 'group'].map(function(target) {
                                    var targetBemjson = {
                                        elem: 'option',
                                        attrs: { value: target },
                                        content: apply('target-text', { 'ctx.target': target })
                                    };

                                    if (target === itemData.target) {
                                        targetBemjson.attrs.selected = 'selected';
                                    }

                                    return targetBemjson;
                                }, this)
                            }
                        ]
                    },
                    {
                        elem: 'target-info-group',
                        itemData: itemData
                    },
                    {
                        elem: 'target-info-campaign',
                        itemData: itemData
                    },
                    {
                        block: 'b-control-remove-button',
                        mods: { icon: 'basket' },
                        mix: { block: 'b-minus-phrases-manager', elem: 'phrase-item-remove' },
                        data: { itemId: this.ctx.itemData.id }
                    }
                ]
            };
        }),

        elem('target-info-campaign').content()(function() {
            var itemData = this.ctx.itemData;

            return [
                {
                    block: 'link',
                    target: 'blank',
                    url: u.getUrl('showCamp', {
                        ulogin: u.consts('ulogin'),
                        cid: itemData.cid
                    }),
                    content: u.hellipCut(itemData.campName, 22),
                    title: itemData.campName
                },
                {
                    elem: 'target-info-id',
                    content: itemData.cid
                }
            ];
        }),

        elem('target-info-group')(
            mix()(function() {
                var target = this.ctx.itemData.target;

                return [
                    {
                        elemMods: { for: target }
                    },
                    {
                        block: 'i-glue',
                        elem: 'model-field',
                        js: {
                            type: 'mod',
                            name: 'target',
                            block: 'b-minus-phrases-manager',
                            elem: 'target-info-group',
                            modName: 'for'
                        }
                    }
                ];
            }),

            content()(function() {
                var itemData = this.ctx.itemData;

                return [
                    {
                        block: 'link',
                        target: 'blank',
                        mix: {
                            block: 'b-minus-phrases-manager',
                            elem: 'target-info-group-link'
                        },
                        url: u.getUrl('showCamp', {
                            tab: 'all',
                            search_by: itemData.bid ? 'num' : 'group',
                            ulogin: u.consts('ulogin'),
                            search_banner: itemData.bid || itemData.adgroupId,
                            cid: itemData.cid
                        }),
                        content: u.hellipCut(
                            itemData.groupName,
                            this.mods['stat-type'] === 'moc' ? 35 : 20
                        ),
                        title: itemData.groupName
                    },
                    itemData.adgroupId && {
                        elem: 'target-info-id',
                        content: itemData.adgroupId
                    }
                ];
            })
        )
    ),

    mod('stat-type', 'moc').elem('target-info-campaign').def()('')
);
