BEM.MODEL.decl('b-minus-phrases-manager__phrase-item', {

    id: {
        type: 'id',
        internal: false
    },

    bid: 'string',

    cid: 'string',

    campName: 'string',

    adgroupId: 'string',

    groupName: 'string',

    text: 'string',

    prevPhraseHaveAnotherCid: 'boolean',

    target: {
        type: 'enum',
        enum: ['group', 'campaign'],
        default: 'group'
    },

    prevTargetId: {
        type: 'string',
        dependsFrom: ['target'],
        calculate: function(target) {
            return target === 'group' ?
                'c' + this.get('cid') :
                'g' + this.get('adgroupId');
        }
    },

    targetId: {
        type: 'string',
        dependsFrom: ['target'],
        calculate: function(target) {
            return target === 'group' ?
                'g' + this.get('adgroupId') :
                'c' + this.get('cid');
        }
    },

    overflowSymbolsCount: {
        type: 'number',
        default: 0
    },

    errorEmptyPhrase: {
        type: 'string',
        dependsFrom: ['text'],
        calculate: function(text) {
            return text ? false : iget2('b-minus-phrases-manager', 'pole-ne-mozhet-byt', 'Поле не может быть пустым');
        }
    },

    errorFromServer: {
        type: 'string'
    },

    errorSymbolsCount: {
        type: 'string',
        dependsFrom: ['overflowSymbolsCount', 'target'],
        calculate: function() {
            var overflowSymbolsCount = this.get('overflowSymbolsCount');

            return overflowSymbolsCount > 0 ?
                (this.get('target') === 'group' ?
                    iget2(
                        'b-minus-phrases-manager',
                        'dobavlyaemye-frazy-prevyshayut-limit',
                        'Добавляемые фразы превышают лимит минус-фраз на группу на {foo} символов',
                        {
                            foo: overflowSymbolsCount
                        }
                    ) :
                    iget2(
                        'b-minus-phrases-manager',
                        'dobavlyaemye-frazy-prevyshayut-limit-124',
                        'Добавляемые фразы превышают лимит минус-фраз на кампанию на {foo} символов',
                        {
                            foo: overflowSymbolsCount
                        }
                    )
                ) :
                '';
        }
    },

    error: {
        type: 'string',
        dependsFrom: ['errorEmptyPhrase', 'errorSymbolsCount', 'errorFromServer'],
        calculate: function(fields) {
            return fields.errorEmptyPhrase || fields.errorSymbolsCount || fields.errorFromServer;
        }
    },

    haveError: {
        type: 'boolean',
        dependsFrom: ['error'],
        calculate: function(error) {
            return !!error;
        }
    },

    report_row_hash: 'string'

});
