block('b-minus-words-control')(

    def()(function() {
        var switcherType = this.ctx.switcherType || 'button',
            minusWordsPreviewTextLength = 50,
            minusWordsText = this.ctx.minusWords || [];

        return applyNext({
            'ctx.switcherType': switcherType,
            'ctx.minusWordsText': u.hellipCut(
                u.minusWords.arrayToString(minusWordsText),
                minusWordsPreviewTextLength,
                u.escapeHTML
            ),
            minusWordsPreviewTextLength: minusWordsPreviewTextLength,
            hintAboveControl: this.ctx.hintAboveControl || false,
            hintMixes: this.ctx.hintMixes || []
        });
    }),

    js()(function() {
        return {
            minusWordsPreviewTextLength: this.minusWordsPreviewTextLength,
            minusWords: this.ctx.minusWords,
            modelParams: this.ctx.modelParams,
            switcherType: this.ctx.switcherType,
            modal: this.ctx.modal || false,
            isSuperReaderControl: this.ctx.isSuperReaderControl
        };
    }),

    content()(function() {
        return [
            !!this.ctx.showPreview && this.ctx.hintAboveControl && {
                elem: 'minus-words-preview',
                mix: [
                    {
                        block: 'b-outboard-controls',
                        elem: 'data-hint',
                        elemMods: { type: 'tail' }
                    }
                ].concat(this.ctx.hintMixes),
                content: this.ctx.minusWordsText
            },
            {
                block: 'b-outboard-controls',
                js: { id: 'minus-words-control-' + this.ctx['for'] },
                content: {
                    block: 'b-minus-words-control',
                    elem: 'switcher',
                    elemMods: { type: this.ctx.switcherType },
                    js: {
                        innerBlockParams: {
                            modelParams: this.ctx.modelParams,
                            requestParams: this.ctx.requestParams
                        }
                    },
                    content: this.ctx.switcherType === 'link' ?
                        {
                            block: 'link',
                            mods: {
                                pseudo: 'yes',
                                theme: (this.ctx.switcherMods && this.ctx.switcherMods.theme) || 'normal'
                            },
                            url: '#',
                            mix: {
                                block: 'b-minus-words-control',
                                elem: 'switcher-link'
                            },
                            content: this.ctx.switcherText
                        } :
                        {
                            block: 'button',
                            mods: { theme: this.ctx.theme || 'normal' },
                            mix: {
                                block: 'b-minus-words-control',
                                elem: 'switcher-button'
                            },
                            content: {
                                block: 'b-minus-words-control',
                                elem: 'switcher-text',
                                content: this.ctx.switcherText || this.ctx.minusWords &&
                                    this.ctx.minusWords.length ? iget2('b-minus-words-control', 'izmenit', 'Изменить') : iget2('b-minus-words-control', 'dobavit', 'Добавить')
                            }
                        }
                }
            },
            !!this.ctx.showPreview && !this.ctx.hintAboveControl && {
                elem: 'minus-words-preview',
                mix: [
                    {
                        block: 'b-outboard-controls',
                        elem: 'data-hint',
                        elemMods: { type: 'tail' }
                    }
                ],
                content: this.ctx.minusWordsText
            },
            !!this.ctx.minusWordsHiddenName && {
                name: this.ctx.minusWordsHiddenName,
                block: 'b-minus-words-control',
                elem: 'minus-words-hidden',
                value: this.ctx.minusWords
            }
        ];
    }),

    elem('minus-words-hidden')(
        tag()('input'),

        attrs()(function() {
            return {
                type: 'hidden',
                name: this.ctx.name,
                value: JSON.stringify(this.ctx.value)
            };
        })
    ),

    elem('popup').content()(function() {
        return {
            block: 'b-outboard-controls',
            mods: { modal: this.ctx.modal ? 'yes' : '' },
            js: { id: 'minus-words-control-' + this.ctx['for'] },
            content: {
                elem: 'popup',
                header: iget2('b-minus-words-control', 'minus-frazy', 'Минус-фразы'),
                autoclosable: 'yes',
                adaptive: 'yes',
                disabled: 'yes',
                directions: this.ctx.for === 'campaign' ? ['left'] : ['right'],
                innerBlock: {
                    block: 'b-minus-words',
                    mods: this.ctx.minusWordsMods,
                    limit: this.ctx.limit,
                    mix: [{
                        block: 'b-minus-words-control',
                        elem: 'popup'
                    }]
                }
            }
        };
    })
);
