/**
 *
 * @event b-minus-words-control#popup-show popup стал виден
 * @event b-minus-words-control#save-click клик по кнопке "Сохранить"
 *
 * @fires b-minus-words-control#popup-show popup
 * @fires b-minus-words-control#save-click
 */
BEM.DOM.decl('b-minus-words-control', {

    onSetMod: {
        js: function() {
            var outboard = this._getOutboardControls();
            if (this.params.isSuperReaderControl) {
                this._disableAcceptButton();
            }

            this._initEvents();

            outboard.on('show', function() {
                this.trigger('popup-show');
                BEM.blocks['b-metrika2'].params({
                    params: {
                        showCamp: {
                            'common-negative-keywords': 'show'
                        }
                    }
                });
            }, this);
            outboard.on('accept', function() {
                this.trigger('save-click');
                BEM.blocks['b-metrika2'].params({
                    params: {
                        showCamp: {
                            'common-negative-keywords': 'save'
                        }
                    }
                });
            }, this);
            // для первого открытия popup - когда происходит инициализация popup может быть уже открытым
            outboard.isShown() && this.trigger('popup-show');
        }
    },

    _toggleOutboard: function() {
        var outboard = this._getOutboardControls(),
            switcher = this.elem('switcher'),
            toggler = this.params.modal ? undefined : switcher;

        outboard.callInnerMethod('prepareToShow', this.elemParams(switcher).innerBlockParams);
        outboard.popup.toggle(toggler);
        outboard.getInnerBlock().elem('input').focus();
        return this;
    },

    /**
     * подписывается на изменение минус-слов баннера и блока b-outboard-controls
     * @private
     */
    _initEvents: function() {
        BEM.MODEL
            .getOne(this.params.modelParams)
            .on('fix', function(e) {
                this._updateMinusWords(e.target.get('minus_words'));
            }, this);

        this
            ._getOutboardControls()
            .getInnerBlock()
            .on('state', this._onStateChange, this);
    },

    /**
     * callback на фиксацию минус-слов в модели баннера
     * изменяет значение минус-слов в DOM элементах
     *
     * @param {Array} minusWords
     * @private
     */
    _updateMinusWords: function(minusWords) {
        minusWords = u.minusWords.arrayToString(minusWords);

        this.elem('minus-words-preview')
            .html(u.hellipCut(minusWords, this.params.minusWordsPreviewTextLength, u.escapeHTML));

        if (this.elem('minus-words-hidden')) {
            this.elem('minus-words-hidden').val(JSON.stringify(u.minusWords.stringToArray(minusWords)));
        }

        this.elem('switcher-text') && this.elem('switcher-text')
            .text(minusWords.length ? iget2('b-minus-words-control', 'izmenit', 'Изменить') : iget2('b-minus-words-control', 'dobavit', 'Добавить'));
    },

    /**
     * показывает/скрывает процесс загрузки
     * @param {Object} e
     * @param {Object} params
     * @private
     */
    _onStateChange: function(e, params) {
        // идентификаторы сравниваются для случая ajax-запроса при мультиредактировании групп,
        // чтобы запрос из одного попапа, не повлиял на другой
        // DIRECT-43664 проверка на undefined для случая создания новой кампании
        // оба id в такой ситуации undefined и происходи ложное срабатывание
        if (params.modelId !== undefined && params.modelId === this.params.modelParams.id) {
            this[params.canSave ? '_hideLoading' : '_showLoading']();
        }
    },

    /**
     * меняет надпись на кнопке во время проверки слов на сервере
     * @private
     */
    _showLoading: function() {
        this._acceptButtonText = this._getOutboardControls().getAcceptButtonText();
        this._setAcceptButtonText(iget2('b-minus-words-control', 'sohranyaetsya', 'Сохраняется') + '...');
    },

    /**
     * восстанавливает запись на кнопке после ответа сервера
     * @private
     */
    _hideLoading: function() {
        this._setAcceptButtonText(this._acceptButtonText);
    },

    /**
     * выставляет надпись на кнопке попапа
     * @param {String} text
     * @private
     */
    _setAcceptButtonText: function(text) {
        this._getOutboardControls().setAcceptButtonText(text);
    },

    /**
     * Делает неактивной кнопку "Сохранить" в попапе
     * @private
     */
    _disableAcceptButton: function() {
        this._getOutboardControls().disableAcceptButton();
    },

    /**
     * @returns {Object} блок b-outboard-controls
     * @private
     */
    _getOutboardControls: function() {

        return this._outboardControls || (this._outboardControls = this.findBlockInside('b-outboard-controls'));
    },

    _onButtonClick: function(e) {
        if (this.elem('switcher-button').is(e.block.domElem)) {
            this._toggleOutboard();
        }
    },

    _onLinkClick: function(e) {
        if (this.elem('switcher-link').is(e.block.domElem)) {
            this._toggleOutboard();
        }
    }

}, {
    live: function() {
        this.liveInitOnBlockInsideEvent('click', 'button', function(e) { this._onButtonClick(e); })
            .liveInitOnBlockInsideEvent('click', 'link', function(e) { this._onLinkClick(e); });
    },

    /**
     * Проверяет минус слова баннеров, если у них менялись ключевые фразы
     * @param {Array|Object} bannersGroups модель группы баннеров или массив моделей групп баннеров
     * @param {Object} campModel модель кампании
     * @param {Function} [onSuccess] Обработчик, вызываемый, в случае успеха
     * @param {Function} [onError] Обработчик, вызываемый при ошибке
     * @param {Object} [context] Контекст вызова обработчиков
     */
    checkBanners: function(bannersGroups, campModel, onSuccess, onError, context) {
        var params = {},
            changeAdgroupIds = [],
            onErrorCallback = onError,
            ctx = context;

        // Если передана одна модель, а не массив
        if (!Array.isArray(bannersGroups)) bannersGroups = [bannersGroups];

        // Если пропущен onError параметр
        if (arguments.length === 4 && !$.isFunction(onError)) {
            ctx = onErrorCallback;
            onErrorCallback = $.noop;
        }
        bannersGroups.forEach(function(bannersGroupModel) {
            if (bannersGroupModel.isPhrasesChanged() || bannersGroupModel.isChanged('new_phrases') ||
                bannersGroupModel.isChanged('minus_words')) {

                var adgroupId = bannersGroupModel.get('adgroup_id'),
                    newPhrases = bannersGroupModel.get('new_phrases'),
                    phrases = [].concat(bannersGroupModel.getPhrases(), newPhrases || []);

                changeAdgroupIds.push(adgroupId);
                params['json_minus_words-' + adgroupId] = JSON.stringify(bannersGroupModel.get('minus_words'));
                params['json_key_words-' + adgroupId] = JSON.stringify(phrases);
            }
        });

        // Если ключевые фразы баннеров менялись
        if (changeAdgroupIds.length) {
            // то делаем запрос на проверку
            params.adgroup_ids = changeAdgroupIds.join(',');

            BEM.blocks['b-minus-words'].sendRequest(
                params,
                { for: 'banners', cid: campModel.get('cid') },
                function(errors) {
                    if (!errors || !errors.problem || errors.ok) {
                        onSuccess.call(ctx); // если пересечений нет
                    }

                    // если пересечения есть - показываем конфирм
                    if (errors.problem) {
                        BEM.blocks['b-confirm'].open({
                            limited: true,
                            textYes: iget2('b-minus-words-control', 'ok-123', 'ОК'),
                            textNo: iget2('b-minus-words-control', 'otmena', 'Отмена'),
                            message: errors.problem,
                            onYes: onSuccess,
                            onNo: onErrorCallback
                        }, ctx);
                    }
                },
                onSuccess.bind(ctx), // ошибку от сервера - считаем как успех проверки
                ctx);
        } else {
            // ...иначе просто вызываем обработчик success
            onSuccess.call(ctx);
        }
    }
});
