BEM.DOM.decl({ block: 'b-minus-words', baseBlock: 'i-glue', implements: 'i-outboard-controls' }, {

    /**
     * вызывает установку текущей модели, выставляет параметры для запроса на сервер
     * @param {Object} params
     */
    prepareToShow: function(params) {
        this._setCurrentModel(params);
        this._requestParams = params.requestParams;
    },

    /**
     * по переданным параметрам находит и выставляет модель как текущую,
     * вызывает подписку на прослушивание минус слов между текущей моделью и моделью минус слов
     * @param {Object} params
     * @private
     */
    _setCurrentModel: function(params) {
        this._currentModel && this._unbindCurrentModel();
        this._currentModel = BEM.MODEL.getOrCreate(params.modelParams);
        this._updateMinusWordsModel();

        this._bindCurrentModel();
    },

    /**
     * Обновляем состояния кнопок контрола
     * @private
     */
    _updateState: function() {
        this.trigger('state', { canSave: !this._getTextarea().isLimitExceeded() });
    },

    /**
     * Устанавливает минус слова из текущей модели в модель минус слов
     * @private
     */
    _updateMinusWordsModel: function() {

        this.model.set('minus_words', this._currentModel.get('minus_words'));
    },

    /**
     * Устанавливает минус слова из модели минус слов в текущую модель
     * @private
     */
    _updateCurrentModel: function() {

        this._currentModel.set('minus_words', this.model.get('minus_words'));
    },

    /**
     * Возвращает инпут
     * @private
     */
    _getTextarea: function() {
        return this._textarea ||
            (this._textarea = this.findBlockInside({ block: 'input', modName: 'type', modVal: 'textarea' }));
    },

    /**
     * вызывает отписку от изменения минус слов текущей модели и модели минус слов
     * @private
     */
    _unbindCurrentModel: function() {
        this._updateBinding('un');
    },

    /**
     * вызывает подписку на изменение минус слов текущей модели и модели минус слов
     * @private
     */
    _bindCurrentModel: function() {
        this._updateBinding('on');
    },

    /**
     * подписывает/отписывает на изменение минус слов в текущей модели и модели минус слов
     * @param {String} type
     * @private
     */
    _updateBinding: function(type) {
        var textarea = this._getTextarea();

        this._currentModel[type]('minus_words', 'change', this._updateMinusWordsModel, this);

        textarea[type]('change', this._updateState, this);
        textarea[type]('blur', this._updateCurrentModel, this);
    },

    /**
     * вызывает фикс модели
     */
    provideData: function() {
        this._currentModel.fix();
    },

    /**
     * при необходимости вызывает отправку слов на сервер для проверки
     */
    confirmAccept: function() {
        return this._needToCheckWords() ? this._ajaxCheck() : true;
    },

    /**
     * вызывает откат полей текущей модели
     */
    declineChange: function() {
        var field = this._currentModel.fields.minus_words;

        field && field.rollback();
    },

    /**
     * нужно ли отсылать слова на сервер для проверки
     * @returns {Boolean}
     */
    _needToCheckWords: function() {
        //если onSuccessSave, то в любом случае гонять  аякс-запрос - надо сохранить
        return this._requestParams.onSuccessSave || !!(this._requestParams.cid &&
            !this._currentModel.isEmpty('minus_words') &&
            this._currentModel.isChanged('minus_words'));
    },

    /**
     * отправляет слова на сервер для проверки
     * блокирует/разблокирует возможность повторной отправки
     */
    _ajaxCheck: function() {
        var defer = $.Deferred(),
            _this = this,
            modelId = _this._currentModel.id;

        this.trigger('state', { canSave: false, modelId: modelId });

        this._sendRequest(false)
            .done(function(data) {
                var problem = u.escapeHTML(data.problem);

                if (data.ok) {
                    defer.resolve();
                } else {
                    if (data.can_force_save) {
                        _this._confirm(problem)
                            .done(function() {
                                _this._sendRequest(true).done(
                                    function(forceData) {
                                        forceData.ok ? defer.resolve() : defer.reject();
                                    });
                            })
                            .fail(function() { defer.reject(); });
                    } else {
                        _this._alert(problem).always(function() { defer.reject(); });
                    }
                }
            });

        defer.always(function() {
            _this.trigger('state', { canSave: true, modelId: modelId });
        });

        return defer.promise();
    },

    /**
     * возвращает параметры запроса для проверки минус слов на сервере
     * @returns {Object}
     * @private
     */
    _getAjaxRequestData: function(forceSave) {
        var params = this._requestParams,
            currentModel = this._currentModel,
            minusWords = JSON.stringify(currentModel.get('minus_words')),
            queryData = {},
            keyWords = [];

        if (this._requestParams['for'] !== 'campaign' && currentModel.getPhrasesModels()) {
            keyWords = JSON.stringify([].concat(currentModel.getPhrases(), currentModel.get('new_phrases')));
        }

        // DIRECT-39849 принудительное сохранение
        if (forceSave) {
            queryData.force_save = 1;
        }

        if (params.adgroup_id) {
            queryData.adgroup_ids = params.adgroup_id;
            queryData['json_minus_words-' + params.adgroup_id] = minusWords;

            //DIRECT-48222 DIRECT-45916
            //@heliarian у динамических групп нет фраз, их не надо проверять
            if (!/^(dynamic|performance)$/.test(currentModel.getCampaignModel().get('mediaType')) && (
                currentModel.isPhrasesChanged() || currentModel.isChanged('new_phrases'))) {
                queryData['json_key_words-' + params.adgroup_id] = keyWords;
            }

        } else {
            queryData['json_minus_words-0'] = minusWords;
            queryData['json_key_words-0'] = keyWords;
        }

        return queryData;
    },

    /**
     * выполняет запрос на сервер для проверки минус слов
     * @private
     */
    _sendRequest: function(forceSave) {

        var defer = $.Deferred();

        BEM.blocks['b-minus-words'].sendRequest(
            this._getAjaxRequestData(forceSave),
            this._requestParams,
            function(data) {
                defer.resolve(data);
            },
            function() {
                this._alert(iget2('b-minus-words', 'oshibka-zaprosa-poprobuyte-eshchyo', 'Ошибка запроса. Попробуйте ещё раз.')).always(function() {
                    defer.reject();
                });
            },
            this);

        return defer.promise();
    },

    /**
     * показывает окно подтверждения
     * @param {String} message текст сообщения
     * @private
     */
    _confirm: function(message) {
        var defer = $.Deferred();

        BEM.blocks['b-confirm'].open({
            limited: true,
            overflowHidden: true,
            textYes: iget2('b-minus-words', 'ok-123', 'ОК'),
            textNo: iget2('b-minus-words', 'otmena', 'Отмена'),
            message: [message],
            fromPopup: this.findBlockOutside('popup'),
            onYes: function() { defer.resolve(); },
            onNo: function() { defer.reject(); }
        });

        return defer.promise();
    },

    /**
     * Сообщает об ошибке
     * @private
     */
    _alert: function(message) {
        var defer = $.Deferred();
        BEM.blocks['b-confirm'].open({
            message: message,
            type: 'alert',
            onYes: function() {
                defer.resolve();
            }
        });

        return defer.promise();
    }

}, {

    /**
     *
     * @param {Object} reqData
     * @param {String} [reqData.key_words-{bid}] - ключевики баннера bid
     * @param {String} [reqData.minus_words] - общие минус слова на кампанию bid
     * @param {String} [reqData.minus_words-{bid}] - общие минус слова на баннер bid
     * @param {String} [reqData.bids] - строка с id баннеров по которым выполняется сравнение (в формате 'id1, id2, id3')
     * @param {Object} reqOpt - параметры с которыми посылается ajax-запрос
     * @param {Boolean} [reqOpt.cid] - id кампании
     * @param {Boolean} [reqOpt.isMediaplan] - является ли баннер медиапланом
     * @param {Boolean} [reqOpt.onSuccessSave] - нужно ли сохранять минус-слова после успешной проверки
     * @param {[banners|campaign]} [reqOpt.for] - минус слова для баннера или кампании
     * @returns {Object}
     * @private
     */
    _getAjaxParams: function(reqData, reqOpt) {
        var queryData = {
            cmd: reqOpt['for'] === 'groups' ? 'ajaxCheckBannersMinusWords' : 'ajaxCheckCampMinusWords',
            cid: reqOpt.cid,
            ulogin: u.consts('ulogin'),
            on_success_save: reqOpt.onSuccessSave
        };

        reqOpt.isMediaplan && (queryData.is_mediaplan = 1);

        return $.extend(queryData, reqData);
    },

    /**
     *
     * @param {Object} reqData
     * @param {String} [reqData.key_words-{bid}] - ключевики баннера bid
     * @param {String} [reqData.minus_words] - общие минус слова на кампанию
     * @param {String} [reqData.minus_words-{bid}] - общие минус слова на баннер bid
     * @param {String} [reqData.bids] - строка с id баннеров по которым выполняется сравнение (в формате 'id1, id2, id3')
     * @param {Object} reqOpt - параметры с которыми посылается ajax-запрос
     * @param {Boolean} [reqOpt.isMediaplan] - является ли баннер медиапланом
     * @param {Boolean} [reqOpt.onSuccessSave] - нужно ли сохранять минус-слова после успешной проверки
     * @param {[banners|campaign]} [reqOpt.for] - минус слова для баннера или кампании
     * @param {Function} onSuccess - коллбэк на успешное выполнение запроса
     * @param {Function} onError - коллбэк на ошибку
     * @param {Object} ctx - контекст выполнения обработчиков
     */
    sendRequest: function(reqData, reqOpt, onSuccess, onError, ctx) {
        this.request = BEM.create('i-request_type_ajax', {
            url: '/registered/main.pl',
            type: 'POST',
            cache: false,
            timeout: 110000, // 110 секунд
            dataType: 'json'
        });

        this.request.get(
            this._getAjaxParams(reqData, reqOpt),
            function() { onSuccess.apply(ctx, arguments); },
            function() { onError.apply(ctx, arguments); }
        );

        return this;
    }
});
