block('b-mobile-app-item')(

    tag()('span'),

    mode('app-title')(function() {

        return u.escapeHTML(this.app.name) +
            ' — ' +
            apply('store-name', { app: this.app }) + ' ' +
            apply('country', { app: this.app }) + ' ' +
            this.app.mobileContent.store_content_id
    }),

    mode('name')(function() {
        return applyCtx({
            tag: 'b',
            content: u.escapeHTML(this.app.name)
        });
    }),

    mode('store-name')(function() {
        return { APP_STORE: 'App Store', GOOGLE_PLAY: 'Google Play' }[this.app.store] || '';
    }),

    mode('country')(function() {
        return '(' + this.app.mobileContent.store_country + ')';
    }),

    attrs()(function() {

        return {
            title: apply('app-title', { app: this.ctx.app })
        };
    }),

    content()(function() {
        var app = this.ctx.app;

        return [
            {
                elem: 'app-icon',
                content: {
                    block: 'icon',
                    attrs: { style: 'width:20px; height:20px' },
                    mix: [
                        { block: this.block, elem: 'icon' },
                        { block: 'link', elem: 'icon' }
                    ],
                    url: app.mobileContent.icon_url
                }
            },
            {
                elem: 'app-info',
                content: [
                    apply('name', { app: app }),
                    '&mdash;',
                    apply('store-name', { app: app }),
                    apply('country', { app: app }),
                    app.mobileContent.store_content_id
                ].join('&nbsp;')
            }
        ];
    })
)
