block('b-mobile-app-list')(

    js()(true),

    elem('menu').content()(function() {
        var apps = this.ctx.apps;

        return {
            block: 'menu',
            attrs: {
                tabindex: 0,
                role: 'listbox',
                'aria-selected': true
            },
            mix: {
                block: this.block,
                elem: 'menu'
            },
            mods: { theme: 'normal', size: 'm', type: 'default' },
            items: [
                {
                    items: apps.map(function(app) {
                        return {
                            val: app.id,
                            content: {
                                block: 'b-mobile-app-item',
                                attrs: {
                                    role: 'option'
                                },
                                js: {
                                    id: app.id
                                },
                                mix: {
                                    block: 'b-mobile-app-selector',
                                    elem: 'app'
                                },
                                app: app
                            }
                        };
                    })
                },
                {
                    items: [
                        {
                            elemMods: {
                                'new-app': true
                            },
                            content: {
                                block: 'link',
                                mix: {
                                    block: this.block,
                                    elem: 'new-app'
                                },
                                mods: { pseudo: 'yes', theme: 'black' },
                                content: {
                                    block: this.block,
                                    elem: 'new-app-content',
                                    content: [
                                        {
                                            block: 'icon',
                                            mods: { 'size-12': 'plus' }
                                        },
                                        iget2('b-mobile-app-selector', 'new-other-app-text', 'Добавить другое приложение')
                                    ]
                                }
                            }
                        }
                    ]
                }
            ]
        };
    }),

    content()(function() {
        var apps = this.ctx.apps;

        return [
            {
                elem: 'menu-wrapper',
                content: {
                    elem: 'menu',
                    apps: apps
                }
            }
        ];
    })
);
