BEM.DOM.decl({ block: 'b-mobile-app-list' }, {

    onSetMod: {
        js: function() {
            this._subscriptionManager = BEM.create('i-subscription-manager');
        }
    },

    /**
     * Обновляет список приложений
     * @param {Array<Object>} apps
     */
    updateList: function(apps) {
        var blockName = this.__self.getName();

        BEM.DOM.update(this.elem('menu-wrapper'), BEMHTML.apply({
            block: blockName,
            elem: 'menu',
            apps: apps
        }));
    }

}, {

    live: function() {

        this
            .liveInitOnBlockInsideEvent('click', 'menu', function(e, data) {
                var block = this.findBlockInside('menu').findBlockInside(data.item, 'b-mobile-app-item'),
                    isNewApp = this.findBlockInside('menu').hasMod(data.item, 'new-app', true);

                if (isNewApp) {
                    this.trigger('newApp');
                } else {
                    block && this.trigger('select', { id: block.params.id });
                }
            })
    }

});
