block('b-mobile-app-selector')(

    def()(function() {
        if ((this.ctx.apps || []).length === 0 && !Object.keys(this.ctx.selected).length) {
            this.mods['empty'] = 'yes';
        }

        return applyNext();
    }),

    js()(function() {

        return {
            reqid: this.ctx.reqid,
            apps: this.ctx.apps,
            selected: this.ctx.selected || {},
            infoblockTeasersUrl: this.ctx.infoblockTeasersUrl
        };
    }),

    elem('spin').content()(function() {

        return {
            block: 'spin2',
            mods: {
                size: 'xs',
                progress: 'yes'
            }
        };
    }),

    content()(function() {
        var apps = this.ctx.apps,
            selected = this.ctx.selected;

        return [
            {
                elem: 'new-app-controls',
                content: [
                    {
                        block: 'button2',
                        mix: {
                            block: this.block,
                            elem: 'new-app-button'
                        },
                        mods: {
                            theme: 'normal',
                            view: 'classic',
                            size: 's'
                        },
                        content: {
                            block: this.block,
                            elem: 'new-app-content',
                            content: [
                                {
                                    block: 'icon',
                                    mods: { 'size-12': 'plus' }
                                },
                                iget2('b-mobile-app-selector', 'new-app-text', 'Добавить приложение')
                            ]
                        }
                    },
                    {
                        elem: 'spin'
                    }
                ]
            },
            {
                block: 'dropdown2',
                mix: [
                    {
                        block: this.block,
                        elem: 'dropdown'
                    }
                ],
                mods: {
                    switcher: 'button2',
                    theme: 'normal',
                    size: 's',
                    'has-tick': 'yes',
                    disabled: this.mods.disabled
                },
                switcher: {
                    block: 'button2',
                    mix: {
                        block: this.block,
                        elem: 'dropdown-button'
                    },
                    text: {
                        elem: 'text',
                        content: [
                            u._.get(selected, 'id') ?
                                {
                                    block: 'b-mobile-app-item',
                                    app: selected
                                } :
                                iget2('b-mobile-app-selector', 'placeholder', 'Выберите приложение'),
                        ]
                    }
                },
                popup: {
                    block: 'popup2',
                    directions: ['bottom-left'],
                    content: [
                        {
                            block: 'b-mobile-app-list',
                            mix: {
                                block: this.block,
                                elem: 'list'
                            },
                            apps: apps
                        }
                    ]
                }
            }
        ];
    })
)
