BEM.DOM.decl({ block: 'b-mobile-app-selector' }, {

    // id выбранного приложения
    _selected: null,
    // массив доступных приложений
    _apps: null,
    // менеджер подписок
    _subscriptionManager: null,

    onSetMod: {
        js: function() {

            this._selected = this.params.selected;
            this._apps = this.params.apps;

            this._subscriptionManager = BEM.create('i-subscription-manager');

            this._subscriptionManager.wrap(BEM.blocks['b-mobile-app-list'])
                .on(this.elem('list'), 'select', this._onSelectApp, this)
                .on(this.elem('list'), 'newApp', this._renderCreateAppComponent, this);

            this._subscriptionManager
                .on(this.blockInside('new-app-button', 'button2'), 'click', this._renderCreateAppComponent, this);

            this._subscriptionManager
                .on(this.blockInside('dropdown2'), 'beforeClose', function() {
                    this.blockInside('dropdown-button', 'button2').domElem.focus();
                }, this);

        },
        loading: {
            yes: function() {
                this.blockInside('dropdown2').getPopup().blockInside('b-mobile-app-list').setMod('loading', 'yes');
                this.blockInside('new-app-button', 'button2').setMod('disabled', 'yes');
            },
            '': function() {
                this.blockInside('dropdown2').getPopup().blockInside('b-mobile-app-list').delMod('loading');
                this.blockInside('new-app-button', 'button2').delMod('disabled');
            }
        }
    },

    /**
     * Возвращает id выбранного приложения
     * @return {Number}
     */
    getValue: function() {
        return this._selected;
    },

    /**
     * Получение списка приложений
     * @param {Object} options
     * @param {Object} options.selectLast - выбрать последнее после загрузки
     * @private
     */
    _getAppsList: function(options) {
        var list = this.blockInside('dropdown2').getPopup().blockInside('b-mobile-app-list');

        this.setMod('loading', 'yes');

        return BEM.blocks['i-web-api-request'].mobileApps.getAppsList(u.consts('ulogin'))
            .then(function(res) {
                this._apps = res.result || [];

                list.updateList(this._apps);

                if (this._apps.length) {
                    if (options.selectLast) {
                        this._onSelectApp({}, { id: this._apps[this._apps.length - 1].id });
                    } else if (this._apps.length === 1) {
                        this._onSelectApp({}, { id: this._apps[0].id });
                    }

                    this.delMod('empty');
                } else {
                    this._selected = null;
                    this.setMod('empty', 'yes');
                }

                this.delMod('loading');
            }.bind(this))
            .catch(function() {
                BEM.blocks['b-confirm'].alert(
                    iget2('b-mobile-app-selector', 'error-fetch-list', 'Произошла ошибка при обновлении списка приложений. Пожалуйста перезагрузите страницу.')
                );
                this.delMod('loading');
            }.bind(this));
    },

    /**
     * Обработчик выбора приложения
     * @param {Event} e - событие
     * @param {Object} data - данные события
     * @param {Number} data.id - id выбранного приложения
     * @private
     */
    _onSelectApp: function(e, data) {
        var app = u._.find(this._apps, { id: data.id });

        this._selected = data;
        this._setAppToSwitcher(app);
        this.blockInside('dropdown2').delMod('opened');
        this.trigger('change', app);
    },

    /**
     * Вставляет данные приложения в кнопку
     * @param {Object} app - данные приложения
     * @private
     */
    _setAppToSwitcher: function(app) {

        BEM.DOM.update(
            this.blockInside('dropdown-button', 'button2').elem('text'),
            BEMHTML.apply({
                block: 'b-mobile-app-item',
                app: app
            })
        );
    },

    /**
     * Возвращает попап для отображения компонента добавления приложения
     * @returns {BEM}
     * @private
     */
    _getPopup: function() {
        return BEM.blocks['b-shared-popup'].getInstance({
            theme: 'ffffff',
            type: 'modal',
            poll: 'size',
            'body-scroll': 'no',
            'has-close': 'yes',
            'content-adaptive': 'yes',
            autoclosable: 'no',
            position: 'fixed'
        }, {}, { popup: { block: 'b-mobile-app-selector', elem: 'create-popup' } }, { type: 'paranja' });
    },

    /**
     * Рендерим DNA компонент добавления приложения в попапе
     * @private
     */
    _renderCreateAppComponent: function() {
        var popup = this._getPopup(),
            createElem = $(BEMHTML.apply({
                block: 'b-mobile-app-selector',
                elem: 'create-component'
            })),
            dna = window.dna,
            dnaRootComponent = dna.reactCreateElement(dna.components.MobileAppsCreateSingle, {
                perlReqId: this.params.reqid,
                login: u.consts('ulogin'),
                extOnSaveCallback: function() {
                    popup.hide();
                    this._getAppsList({ selectLast: true });
                }.bind(this),
                extOnCancelCallback: function() {
                    popup.hide();
                }.bind(this),
                infoblockTeasersUrl: this.params.infoblockTeasersUrl,
                clientFeatures: u.consts('clientFeaturesAll'),
                operatorFeatures: u.consts('operatorFeaturesAll')
            }, null);

        dna.reactDOMRender(dnaRootComponent, createElem[0]);

        popup.setContent(createElem).show();
    },

    _onButtonKeydown: function(e) {
        var keycodes = BEM.blocks.keycodes;

        if (!this.blockInside('dropdown2').hasMod('opened') && keycodes.is(e.keyCode, 'UP', 'DOWN')) {
            e.preventDefault();
            this.blockInside('dropdown2').setMod('opened', 'yes');
            this.blockInside('dropdown2').getPopup().blockInside('menu').setMod('focused', 'yes');
        }
    },

    destruct: function() {
        this._subscriptionManager.dispose();
        this._subscriptionManager.destruct();

        this.__base.apply(this, arguments);
    }

}, {
    live: function() {

        this
            .liveBindTo('dropdown-button', 'keydown', function(e) {
                this._onButtonKeydown(e);
            });

        return false;
    }
});
