/**
 * Блок редактирования дополнительных параметров баннера рекламы мобильных приложений
 * @param {String} cid Идентификатор кампании
 * @param {Object} banner Объект с полями баннера, нужными для блока
 * @param {String} banner.modelId Идентификатор модели, должен совпадать с баннером
 * @param {String} banner.image Название файла изображения для баннера
 * @param {String} banner.image_name Хэш изображения для баннера
 * @param {{name: String, id: Number}} banner.video_resources Информация о видео
 * @param {String} clientId Идентификатор клиента
 * @param {Object} strategy Информация об установленной стратегии кампании
 * @param {Object} bannerModelParams Объект с параметрами модели баннера
 * @param {Array} enabledAttrs Атрибуты доступные для мобильного контента
 * @param {Array} showAttrs Атрибуты мобильного контента отображаемые в баннере
 * @param {Boolean} isCorruptedData Флаг неполных данных
 * @param {Boolean} isVideoEnabled Флаг лоступности видеодополнения
 */
block('b-mobile-content-additions')(

    def()(function() {
        var attrsNames = {
                rating: 'rating',
                price: 'price',
                icon: 'icon',
                ratingVotes: 'rating_votes'
            },
            attrsToMap = function(attrs) {
                return (attrs || []).reduce(function(map, attr) {
                    map[attr] = true;

                    return map;
                }, {});
            },
            enabledAttrs = attrsToMap(this.ctx.enabledAttrs),
            showAttrs = attrsToMap(this.ctx.showAttrs),
            isAttrEnabled = function(field) {
                return !!enabledAttrs[attrsNames[field]];
            },
            isAttrSet = function(field) {
                return !!showAttrs[attrsNames[field]];
            },
            modelData = Object.keys(attrsNames).reduce(function(data, key) {
                if (isAttrEnabled(key)) {
                    data[key] = isAttrSet(key);
                    data[key + 'Disabled'] = false;
                } else {
                    data[key] = false;
                    data[key + 'Disabled'] = true;
                }

                return data;
            }, {}),
            banner = this.ctx.banner;

        modelData.isCorruptedData = this.ctx.isCorruptedData;

        return applyNext({
            _modelData: modelData,
            banner: banner
        });
    }),

    js()(function() {
        return {
            modelParams: {
                name: 'b-mobile-content-additions',
                id: this.ctx.banner.modelId,
                data: this._modelData
            }
        };
    }),

    content()(function() {
        var enabledAttrs = this.ctx.enabledAttrs,
            showAttrs = this.ctx.showAttrs,
            attrsName = {
                rating: iget2('b-mobile-content-additions', 'reyting', 'Рейтинг'),
                price: iget2('b-mobile-content-additions', 'cena', 'Цена'),
                icon: iget2('b-mobile-content-additions', 'ikonka', 'Иконка'),
                rating_votes: iget2('b-mobile-content-additions', 'kolichestvo-ocenok', 'Количество оценок')
            };

        return [
            {
                block: 'b-model-form-error',
                mix: [
                    { block: 'b-model-form-error', elem: 'control' },
                    { block: 'b-mobile-content-additions', elem: 'form-error' }
                ],
                modelParams: this.ctx.bannerModelParams,
                field: 'image_model'
            },
            {
                elem: 'content',
                content: [
                    {
                        block: 'select2',
                        mix: [
                            {
                                block: 'b-mobile-content-additions',
                                elem: 'model-field',
                                js: {
                                    name: 'attrs',
                                    type: 'select2'
                                }
                            },
                            {
                                block: 'b-mobile-content-additions',
                                elem: 'attrs-select'
                            }
                        ],
                        mods: {
                            type: 'check',
                            theme: 'normal',
                            size: 's',
                            text: 'vary',
                            width: 'max'
                        },
                        text: iget2('b-mobile-content-additions', 'data-of-application', 'Данные о приложении: рейтинг, цена, иконка, количество скачиваний'),
                        name: 'select2',
                        val: showAttrs,
                        items: Object.keys(attrsName).map(function(attr) {
                            return {
                                val: attr,
                                mix: {
                                    block: 'b-mobile-content-additions',
                                    elem: 'model-field',
                                    js: {
                                        name: attr === 'rating_votes' ? 'ratingVotesItemDisabled' : (attr + 'Disabled'),
                                        type: 'mod',
                                        block: 'menu',
                                        elem: 'item',
                                        modName: 'disabled'
                                    }
                                },
                                text: attrsName[attr],
                                elemMods: { disabled: enabledAttrs && u._.includes(enabledAttrs, attr) ? '' : 'yes' }
                            }
                        },[])
                    }
                ]
            },
            {
                elem: 'corrupted-data-warning',
                elemMods: { visible: this._modelData.isCorruptedData ? 'yes' : '' },
                mix: {
                    block: 'b-mobile-content-additions',
                    elem: 'model-field',
                    js: {
                        name: 'isCorruptedData',
                        type: 'mod',
                        block: 'b-mobile-content-additions',
                        elem: 'corrupted-data-warning',
                        modName: 'visible'
                    }
                }
            }
        ];
    }),

    elem('corrupted-data-warning').content()(function() {
        return {
            block: 'icon-text',
            mods: {
                theme: 'alert',
                size: 's'
            },
            mixes: {
                icon: {
                    block: 'b-mobile-content-additions',
                    elem: 'corrupted-data-warning-icon'
                }
            },
            text: [
                {
                    elem: 'warning-text',
                    tag: 'span',
                    content: iget2('b-mobile-content-additions', 'chast-dannyh-ne-udalos', 'Часть данных не удалось получить из магазина приложений')
                },
                {
                    block: 'b-help-link',
                    mods: {
                        type: 'modal'
                    },
                    stretched: true,
                    url: u.getHelpUrl('advertising-mobile-apps-update')
                }
            ]
        };
    })
);
