BEM.MODEL.decl({ model: 'b-mobile-content-additions', baseModel: 'vm-sync-dm2' }, {

    _dmDecl: {
        type: 'object',
        internal: true,
        calculate: function() {
            return {
                banner: {
                    name: 'dm-mobile-content-banner',
                    id: this.id
                }
            };
        }
    },

    // состояние рейтинга
    ratingDisabled: 'boolean',

    // состояние цены
    priceDisabled: 'boolean',

    // состояние иконки
    iconDisabled: 'boolean',

    // состояние количества ревью
    ratingVotesDisabled: 'boolean',

    // состояние чекбокса, количества ревью
    // отдельное поле потому, что чекбокс не должен быть активен,
    // если не включен рейтинг и нет данных о количестве оценок
    ratingVotesItemDisabled: {
        type: 'boolean',
        calculate: function() {
            var attrs = this.get('attrs'),
                ratingVotesDisabled = this.get('ratingVotesDisabled');

            return !!(attrs && (attrs.length && attrs.indexOf('rating') === -1) || ratingVotesDisabled);
        },
        dependsFrom: ['attrs', 'ratingVotesDisabled']
    },

    // Отображаемые атрибуты, синхронизируется с DM
    attrs: 'array',

    // Отображать сообщение о неполных данных
    isCorruptedData: 'boolean'

}, {

    /**
     * Хеш соответствия внутренних полей модели, значениям в reflected_attrs
     */
    _attrsNames: {
        rating: 'rating',
        price: 'price',
        icon: 'icon',
        ratingVotes: 'rating_votes'
    },

    init: function() {
        var dm = this.getDM().banner,
            attrs = Object.keys(this._attrsNames);

        dm.getGroup().on('mobile_content', 'change', $.debounce(function() {
            var mobileContent = dm.getGroup().get('mobile_content').toJSON(),
                enabledAttrs = u['dm-mobile-content'].getAvailableAttrs(mobileContent);

            attrs.forEach(function(fieldName) {
                this.set(fieldName + 'Disabled', enabledAttrs.indexOf(this._attrsNames[fieldName]) === -1);
            }, this);

            this.set('isCorruptedData', u['dm-mobile-content'].isCorruptedData(mobileContent));
        }, 10), this);

        dm.on('reflected_attrs', 'change', $.debounce(function() {
            var value = dm.get('reflected_attrs');

            this.set('attrs', value);
        }, 10), this);

        this.set('attrs', dm.get('reflected_attrs'));

        this.on('attrs', 'change', $.debounce(function() {
            dm.set('reflected_attrs', this.get('attrs'));
        }, 10), this);

        this.on('ratingVotesItemDisabled', 'change', function() {
            if (this.get('ratingVotesItemDisabled')) {
                // uncheck-аем кол-во оценок, если check-нуто
                this.set('attrs', this.get('attrs').filter(function(item) {
                    return item !== 'rating_votes';
                }));
            }
        }, this);
    }
});
