BEM.DOM.decl({ block: 'b-mobile-content-creative-adviser' }, {
    onSetMod: {
        js: function() {
            this.model = BEM.MODEL.getOne(this.params.modelParams);

            this.model.on('usedResolutions', 'change', this._updateAdviserContent, this);
        }
    },

    /**
     * Обновление content-a блока b-mobile-content-creative-adviser
     * @private
     */
    _updateAdviserContent: function() {
        var usedResolutions = this.model.get('usedResolutions'),
            dm = this.model.getDM()['dm-mobile-content-banner'];

        BEM.DOM.replace(
            this.findElem('content'),
            BEMHTML.apply({
                block: 'b-mobile-content-creative-adviser',
                elem: 'content',
                usedResolutions: usedResolutions
            })
        );

        if (!dm.get('imageSize') && (usedResolutions.length === u.imageAd.getDefaultResolutionsList().length)) {
            this.model.set('allFormatsSizeAdviserUsed', true);
            this.model.set('hideSizeAdviser', true);
        } else if (!dm.get('imageSize')) {
            this.model.set('hideSizeAdviser', false);
        }
    },

    destruct: function() {
        this.model.un('usedResolutions', 'change', this._updateAdviserContent, this);

        return this.__base.apply(this, arguments);
    }
});
