/**
 * Блок редактирования операционной системы для рекламы мобильного контента
 * @param modelName
 * @param modelId
 * @param contentOsType Семейство ОС для мобильного контента
 * @param [contentMinVersion] Минимальное значение версии ОС для мобильного контента
 * @param value Текущее минимальное значение версии ОС
 */
block('b-mobile-content-os')(
    def()(function() {
        this._osVersions = u.consts('MOBILE_OS_VERSIONS');

        this._contentOsType = this.ctx.contentOsType || 'iOS';
        this._contentMinVersion = this.ctx.contentMinVersion || this._osVersions[this._contentOsType][0];
        this._minVersionValue = this.ctx.value;

        this._availableMinVersion = this._contentMinVersion;

        if (this._minVersionValue && +this._contentMinVersion > +this._minVersionValue) {
            this._showWarning = true;
            this._availableMinVersion = this._minVersionValue;
        }

        return applyNext();
    }),

    js()(function() {
        return {
            modelName: this.ctx.modelName || 'dm-mobile-content-group',
            modelId: this.ctx.modelId,
            osVersions: this._osVersions,
            contentOsType: this._contentOsType,
            contentMinVersion: this._contentMinVersion,
            value: this._minVersionValue
        };
    }),

    content()(function() {
        return [
            {
                elem: 'select'
            },
            {
                elem: 'text',
                content: iget2('b-mobile-content-os', 'ili-bolee-pozdnyaya', 'или более поздняя')
            },
            this._showWarning && {
                elem: 'warning'
            }
        ];
    }),

    elem('select').tag()('span'),

    elem('select').content()(function() {
        return {
            block: 'select',
            js: {
                popupContentMix: {
                    block: 'b-mobile-content-os',
                    elem: 'versions-list'
                }
            },
            mix: {
                block: 'b-mobile-content-os',
                elem: 'model-field',
                js: {
                    name: 'min_os_version',
                    type: 'select'
                }
            },
            content: [
                {
                    block: 'button',
                    content: u.escapeHTML(this._contentOsType + ' ' +
                        (this._minVersionValue || this._contentMinVersion))
                },
                {
                    elem: 'control',
                    content: this._osVersions[this._contentOsType].reduce(function(options, version) {

                        if (+version >= +this._availableMinVersion) {
                            var option = {
                                elem: 'option',
                                attrs: {
                                    value: version
                                },
                                content: u.escapeHTML(this._contentOsType + ' ' + version)
                            };

                            if (version === this._minVersionValue) {
                                option.attrs.selected = 'selected';
                            }

                            options.push(option);
                        }

                        return options;
                    }.bind(this), [])
                }
            ]
        };
    }),

    elem('text').tag()('span'),

    elem('warning').content()(function() {
        return [
            {
                block: 'icon',
                mods: {
                    'size-16': 'alert'
                }
            },
            iget2(
                'b-mobile-content-os',
                'minimalnaya-versiya-poluchennaya-iz',
                'Минимальная версия, полученная из Магазина приложений - {foo} и выше.',
                {
                    foo: this._contentMinVersion
                }
            ),
            '<br/>',
            iget2('b-mobile-content-os', 'obyavlenie-budet-pokazano-na', 'Объявление будет показано на соответствующих устройствах.')
        ];
    })
);
